#ifndef BuildDataOrganizer_H
#define BuildDataOrganizer_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/

//_USE_MATH_DEFINES gives access to Pi as M_PI, and must precede #include <cmath> or <math.h>
#define _USE_MATH_DEFINES
#include <cmath>
#include <algorithm>
#include "Inputs/Inputs.h"
#include "DataOrganizer.h"

//Define constant effective zero value
#define Constant_1E_negative5 1.E-5
//Conversion between fraction and percent
#define Ratio_Decimal_to_Percent 0.01
//Conversion m to mm
#define Ratio_m_to_mm 1.0/1000.0

//MAX function for finding minimum of x_var and y_var using conditional ternary operator (?:)
//Note: Ternary operator explained: For (x_var<=y_var?x_var:y_var), if x_var<=y_var is true, then x_var is taken, otherwise y_var taken.
#define MAX(x_var,y_var) (((x_var)>=(y_var)) ? (x_var) : (y_var))        

class BuildDataOrganizer
{
	public:
		static void BuildDataOrganizer_Manager(DataOrganizer *organizer, Inputs *input, CompactRagged* beC, string Directory_Input_CLArg);
		static void Check_HydroPlusConfig_Inputs(DataFolder* folder, Inputs* input, CompactRagged* beC, string Directory_Input_CLArg, int MapPixel_ID, int DataFolder_ID);
		static void Prepare_GI_PollutantRemoval(DataOrganizer* organizer, Inputs* input, CompactRagged* beC);
		static void BuildDataOrganizer_Spatial(DataOrganizer* organizer, Inputs* input, CompactRagged* beC, string Directory_Input_CLArg);
		static void Folder_CoverData_Spatial(DataFolder* folder, Inputs* input, CompactRagged* beC, int MapPixel_ID, int DataFolder_ID, int Folder_Type_ID);
		static void Catchment_CoverData_FolderType_Summarize_Spatial(Inputs* input, int Folder_Type_ID);
		static void BuildDataOrganizer_Statistical(DataOrganizer *organizer, Inputs *input, CompactRagged* beC, string Directory_Input_CLArg);
		static void Folder_CoverData_Statistical(DataFolder *folder, Inputs* input, CompactRagged* beC, int DataDrawer_ID, int DataFolder_ID);
		static void Catchment_CoverData_FolderType(DataFolder* folder, Inputs* input, CompactRagged* beC, int MapPixel_ID, int DataFolder_ID, int Folder_Type_ID);
};

#endif