#ifndef BlockGroupHandler_H
#define BlockGroupHandler_H

/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include <map>
#include "../DataFolder.h"
#include "../Inputs/Inputs.h"
#include "../Outputs/TemperatureOutputWriter.h"

//using namespace std allows for use of standard namespace without the preface 
using namespace std;

//MIN function for finding minimum of x_var and y_var using conditional ternary operator (?:)
//Note: Ternary operator if x_var>=y_var is true, then x_var is taken, otherwise y_var taken.
#define MIN(x_var,y_var) (((x_var)<=(y_var)) ? (x_var) : (y_var))        
//MAX function for finding maximum of x_var and y_var using conditional ternary operator (?:)
#define MAX(x_var,y_var) (((x_var)>=(y_var)) ? (x_var) : (y_var))        

class BlockGroupHandler
{
  public:
	 //map<int, DataFolder*> BlockGroupIDToItsFolder;
	 BlockGroupHandler(Inputs *);
	 void AddDEMLocationValuesToBlockGroup(Inputs* input, CompactRagged* beC, DataFolder* folder, int blockGroupID, int MapPixel_ID, int DataFolder_ID);
	 void ResetBlockGroupVar_to_zero(Inputs* input, int blockGroupID);
	 void ResetBlockGroupVar_to_zeroDailyValues(Inputs* input, int blockGroupID);
	 void DailyCal(Inputs* input, int blockGroupID, int timeStep);
	 void AddToBlockGroup(Inputs *input, CompactRagged* beC, DataFolder *DEMLocationFolder, int MapPixel_ID, int DataFolder_ID);
	 bool PrintBlockGroupCheck(int DEMLocationIndex, Inputs *input);
	 void TimeStepProcessing(Inputs *input, int timeStep);
	//~BlockGroupHandler();
};

#endif // !BlockGroupHandler_H