#ifndef RootZoneEvapoTranspirationCalc_h
#define RootZoneEvapoTranspirationCalc_h
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include "../Inputs/Inputs.h"
#include "../DataFolder.h"
//include "HeatMetrics_Calc.h" to access HeatMetrics_Calc.cpp functionality 
#include "../CoolAir/HeatMetrics_Calc.h"

//Conversion m to mm
#define Ratio_m_to_mm 1.0/1000.0
//Ratio of Joules to megaJoules
#define Ratio_J_to_MJ 1000000.0
//Define constant effective zero value for meter length
#define Constant_1E_negative6 1.E-6

class RootZoneEvapoTranspirationCalc
{
	public:		
		static void Calculate(Inputs * input, CompactRagged* beC, DataFolder *folder, int TI_bin, int DataDrawer_ID, int DataFolder_ID, int timeStep);
		static void SoilWaterRetentionCurve(Inputs* input, CompactRagged* beC, DataFolder* folder, int TI_bin, int MapPixel_ID, int DataFolder_ID, int timeStep);

};

#endif