#ifndef InfiltrationPowerDecay_H
#define InfiltrationPowerDecay_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include "../Inputs/Inputs.h"
#include "../DataFolder.h"

 //Conversion hour to seconds
#define Ratio_Hour_to_Second 1.0/3600.0

class InfiltrationPowerDecay
{
	public:	
		static void calculate(Inputs *input, CompactRagged* beC, DataFolder *folder, int MapPixel_ID, int DataFolder_ID, int timeStep);
	private:
		static void beforePonding(int bIT, double bR, double bDT, DataFolder *folder, Inputs * input, CompactRagged* beC, int DataDrawer_ID, int DataFolder_ID);
		static void estimateTP(int tpIT, double tpR, double tpDT, DataFolder *folder, Inputs * input, CompactRagged* beC, int DataDrawer_ID, int DataFolder_ID);
		static void inPonding(int ipIT, double ipPP, double ipDT, DataFolder *folder, Inputs *input, CompactRagged* beC, int DataDrawer_ID, int DataFolder_ID);
		static void simpsonIntegration(double IP, double F, double& IR, DataFolder *folder, Inputs *input, CompactRagged* beC, int DataDrawer_ID, int DataFolder_ID);
		static void noPonding(double npR, DataFolder* folder, Inputs *input, int timeStep);
		//Note: calcInfilEXQ function turned off to allow for ponding
		static void calcInfilEXQ(double ifR, DataFolder* folder, Inputs *input, int timeStep);

};

#endif