#ifndef TemperatureOutputWriter_H
#define TemperatureOutputWriter_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include <map>
#include "../Inputs/Inputs.h"
#include "../DataFolder.h"
#include "../DataOrganizer.h"
#include "../Inputs/WeatherProcessor.h"
#include "../CoolAir/HeatFluxCal.h"

using namespace std;

class TemperatureOutputWriter
{
public:
	static int Folder_Type_ID;

	//Generate block group and block group daily files
	static void generate_BlockGroup_Files(Inputs* input);
	//Related functions to create files containing hourly data for block groups i.e. BlockGroup#.txt
	static void createBlockGroupHourlyFile(string outDirectory, int blockGroupIndex);
	static void writeToBlockGroupHourlyFile(Inputs* input, string outDirectory, string date, int blockGroupIndex);

	//Related functions to create files containing daily data for block groups i.e. BlockGroupDaily#.txt
	static void createBlockGroupDailyFile(string outDirectory, int blockGroupIndex);
	static void writeToBlockGroupDailyFile(Inputs* input, string outDirectory, string date, int blockGroupIndex, int timeStep);

	//Related output functions for generating location based files containing hourly data i.e. Row#Col#Hydro.csv & Row#Col#Heat.csv
	static void rowColFileBatchProcessor(int timeStep, int MapPixel_ID, int DataFolder_ID, DataFolder *folder, string outDirectory, Inputs *input, CompactRagged* beC);
	static void generateRowColFiles(DataOrganizer *organizer, Inputs *input);
    
	//createHydroRowColFile function creates Row#Col#Hydro.csv file for writing during time step loop
	static void createHydroRowColFile(int i, int j, string outDirectory, Inputs *input);
	//writeToHydroRowColFile function writes to Row#Col#Hydro.csv file during time step loop
	static void writeToHydroRowColFile(Inputs* input, DataFolder *folder, string outDirectory, int timeStep, int SimulationDate_GDH, int row, int col);

	//createHeatRowColFile function creates Row#Col#Heat.csv file for writing during time step loop
	static void createHeatRowColFile(int i, int j, string outDirectory, Inputs* input);
	//writeToHeatRowColFile function writes to Row#Col#Heat.csv file during time step loop
	static void writeToHeatRowColFile(Inputs* input, CompactRagged* beC, DataFolder* folder, string outDirectory, int MapPixel_ID, int DataFolder_ID, int timeStep, int SimulationDate_GDH, int row, int col);
	
	//createMapBasedResultFile function to write header rows for outputVarName variable, each named for a variable in HydroPlus.sln
	static void createMapBasedResultFile(string outputVarName, int date, Inputs *input);
	//writeToMapBasedResultFile function to write values in map array for outputVarName variable, each named for a variable in HydroPlus.sln
	static void writeToMapBasedResultFile(string outputVarName, int date, string& OutputDirectory_String, DataOrganizer* organizer, Inputs* input, CompactRagged* beC);

	static void MapBasedResultsFileProcessor(DataOrganizer* organizer, string OutputDirectory_String, Inputs* input, CompactRagged* beC, WeatherProcessor* WeatherPro, int timeStep);

private:

};

#endif

