#include "WriteOutputs.h"

//WriteOutputs::TimeSeriesOutput function coordinates time series output
void WriteOutputs::TimeSeriesOutput(Inputs* input, DataOrganizer* organizer, int timeStep)
{
	//If Flag_ExtendedOutputs equals 1 then write time series outputs
	if (input->SimulationNumericalParams["Flag_ExtendedOutputs"] == 1) {
		//WaterBalance_TimeSeries::writeWeatherDriversAndPhenology function will write weather variables and LAI time series
		WaterBalance_TimeSeries::writeWeatherDriversAndPhenology(input, timeStep);
		//WaterBalance_TimeSeries::write_TimeSeries_CatchmentVariables function is only part of ExtendedOutput condition
		WaterBalance_TimeSeries::write_TimeSeries_CatchmentVariables(input, timeStep);
		//WaterQuality_Ouput::writeLoad_by_EMC_via_Catchment_TS function writes catchment EMC generated loads as time series
		WaterQuality_Output::writeLoad_by_EMC_via_Catchment_TS(input, timeStep);

		//If Flag_GI_Simulated equals 1 then GI simulated and compute variable averages
		if (input->RepoDict["Flag_GI_Simulated"] == 1) {
			if (timeStep == 0) {
				//WaterBalance_TimeSeries::writeWaterBalanceHeader_GIUnit function is part of ExtendedOutput and noExtendedOutput conditions
				WaterBalance_TimeSeries::writeWaterBalanceHeader_GIUnit(input, timeStep);
			}
			//WaterBalance_TimeSeries::writeWaterBalanceTS_GIUnit function is part of ExtendedOutput and noExtendedOutput conditions
			WaterBalance_TimeSeries::writeWaterBalanceTS_GIUnit(input, timeStep);
			//WaterQuality_Output::writeLoad_by_EMC_via_GI_TS function writes GI EMC loads as time series
			WaterQuality_Output::writeLoad_by_EMC_via_GI_TS(input, timeStep);
		}
	}
}


//WriteOutputs::SummaryOutput function coordinates end of simulation output
void WriteOutputs::SummaryOutput(DataOrganizer* organizer, Inputs* input)
{
	//writeWaterBalanceFile function reports hydrological variables as catchment simulation sums
	WaterBalance_Summary::writeWaterBalanceFile(input);

	//writeWaterBalanceFile function reports pollutant variables as catchment simulation sums
	WaterQuality_Output::writeLoad_Pollutant_Sum(input);
	//If Flag_GI_Simulated equals 1 then GI simulated and compute variable averages
	if (input->RepoDict["Flag_GI_Simulated"] == 1) {
		//WaterQuality_Output::writeLoad_by_EMC_via_GI_Sum reports GI pollutant variables as catchment simulation sums
		WaterQuality_Output::writeLoad_by_EMC_via_GI_Sum(input);
	}
	//If Flag_CompareToObservedRunoff is not equal to NoCalibration then write discharge calibration files
	//Note: Calibration via command line interface is not currently active
	if (input->SimulationNumericalParams["Flag_CompareToObservedRunoff"] != 0) {
		//WaterBalance_Summary::writeCaliQobs function called to write the observed runoff to the output folder
		//Note: This does not overwrite the observed runoff provided in the input folder
		WaterBalance_Summary::writeCaliQobs(input);
		//WaterBalance_Summary::writeCaliTotalQQ function called to write the predicted runoff to the output folder
		WaterBalance_Summary::writeCaliTotalQQ(input);
	}
}
