#ifndef calibrate_H
#define calibrate_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include "calibrate.h"
#include "../Inputs/Inputs.h"

#include <vector>
#include <string>

using namespace std;

class calibrate 
{
	private:
		//VF = 1 - SUM(abs(Qsim - Qobs)) / SUM (Qobs)
		double VE;
		//CRF1 = 1-SUM(Qobs-Qsim)^2/SUM(Qobs-aveQobs)^2
		double CRF1;
		//CRF2 = 1-SUM|Qobs-Qsim|/SUM|Qobs-aveQobs|
		double CRF2;
		//CRF3 = 1-SUM(sqrt(Qobs)-sqrt(Qsim))^2/SUM(sqrt(Qobs)-sqrt(aveQobs))^2
		double CRF3;
		//SE = mean square error
		double SE;
		//Runoff_Observed_vec_m (m)
		vector<double> Runoff_Observed_vec_m;
		//dailyQobs (m) the summation of 24 hours Q
		vector <double> dailyQobs;  
		//weeklyQobs (m) the summation of 7 days Q
		vector <double> weeklyQobs; 
		//monthlyQobs (m) the summation of 30 days of Q
		vector <double> monthlyQobs; 

	public: 
		calibrate(string Directory_Input_CLArg);
		calibrate(Inputs* input, string Directory_Input_CLArg, double startDate, double endDate);
		calibrate(Inputs* input, vector<double>& Qsim, vector<double>& Qobs);

		int size();
		void objFunRunoff(Inputs* input, vector<double>& );
		// get CRF1
		double getF1();
		// get CRF2
        double getF2();
		// get CRF3
		double getF3();
		// get SE
		double getE();
		double getVE();
		vector<double>& getQobs();
		// for observed runoff
		double operator[] (size_t i) const;
	   
		inline vector<double>& getDailyQobs(){ return dailyQobs; };
		inline vector<double>& getWeeklyQobs(){ return weeklyQobs; };
		inline vector<double>& getMonthlyQobs(){ return monthlyQobs; };

		void calcDailyQobs(Inputs* input);
		void calcWeeklyQobs(Inputs* input);
		void calcMonthlyQobs(Inputs* input);

};

//Note: These functions return the variables Runoff_Observed_vec_m.size(), CRF1, CRF2, CRF3, SE, which are populated
inline int calibrate::size() { return Runoff_Observed_vec_m.size(); }
inline double calibrate::getF1() { return CRF1; }
inline double calibrate::getF2() { return CRF2; }
inline double calibrate::getF3() { return CRF3; }
inline double calibrate::getE() { return SE; }
inline vector<double>& calibrate::getQobs() { return Runoff_Observed_vec_m;}
inline double calibrate::getVE() { return VE; }

#endif