#ifndef SimulationCoordinator_H
#define SimulationCoordinator_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/

//_USE_MATH_DEFINES gives access to Pi as M_PI, and must precede #include <cmath> or <math.h>
#define _USE_MATH_DEFINES
#include <cmath>
#include <math.h>
#include "Inputs/Inputs.h"
#include "DataOrganizer.h"
#include "Inputs/WeatherProcessor.h"

class SimulationCoordinator
{
public:
	static void SimulationCoordinator_Launch(DataOrganizer *organizer, Inputs *input, CompactRagged* beC, WeatherProcessor* WeatherPro, string inputDirectory);
	static void RunStatisticalModel(DataOrganizer *organizer, Inputs *input, CompactRagged* beC, WeatherProcessor* WeatherPro, string inputDirectory);
	static void RunTemperatureSpatialModel(DataOrganizer *organizer, Inputs *input, CompactRagged* beC, WeatherProcessor* WeatherPro, string inputDirectory);
	static void RunCoolRiverModel(DataOrganizer *organizer, Inputs *input, WeatherProcessor* WeatherPro, string inputDirectory);

private:
	static void runCalculations(Inputs* input, CompactRagged* beC, WeatherProcessor* WeatherPro, DataFolder* folder, int MapPixel_ID, int DataFolder_ID, int timeStep);
};

#endif