#include "../Inputs/Inputs.h"
#include "Loading_WaterQuality_EMC.h"
#include <iomanip>
#include <string>
#include <fstream>

//Note: Consider refactor to include pollutants via precipitation to catchment and GI, and to differentiate Exfiltration load as subsurface or groundwater load in Subsurface discharge to ensure Load_GI_Drainage_VadoseZone_Tss_Mean_Sum_kg included in catchment subsurface runoff in Summary_Budget_WaterQualityLoad.dat

//Pollutant_Load_via_EMC function uses vectors Pollutant_Name, Pollutant_ConcentrationMedian_mg_p_L, and Pollutant_ConcentrationMedian_mg_p_L
//Note Inputs.cpp reads Pollutants.csv 2nd row pollutant names, 3rd row median concentrations (mg/L), 4th row mean concentrations(mg/L)
//Note: Pollutant_Name, Pollutant_ConcentrationMedian_mg_p_L, Pollutant_ConcentrationMean_mg_p_L vectors used below are from Pollutants.csv, read in Inputs.cpp into vector 
void Loading_WaterQuality_EMC::Pollutant_Load_via_EMC(Inputs* input, CompactRagged* beC, DataFolder* folder, int DataDrawer_ID, int DataFolder_ID, int timeStep)
{
	double FolderArea_m2 = beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_m2");
	double Runoff_Overland_m = 0;
	double Runoff_Overland_L = 0;
	string Name_Load_Catchment_Pollutant_Median_kg, Name_Load_Catchment_Pollutant_Mean_kg;
	double Load_Catchment_Pollutant_Median_kg = 0;
	double Load_Catchment_Pollutant_Mean_kg = 0;

	//Runoff_Overland_m (m) is sum of Runoff_Pervious_m (m) and Runoff_Impervious_m (m) for time step, at catchment area depths
	//Note: Runoff_Pervious_m (m) and Runoff_Impervious_m (m) contain GI surface runoff scaled to folder area RunoffSummation
	Runoff_Overland_m = folder->VarDict["Runoff_Pervious_m"] + folder->VarDict["Runoff_Impervious_m"];

	//Runoff_Overland_L (L) = Runoff_Overland_m (m) * FolderArea_m2 (m2) * Ratio_L_to_m3
	Runoff_Overland_L = Runoff_Overland_m * FolderArea_m2 * Ratio_L_to_m3;

	//For Loop through pollutant names to write output file header; length of For Loop is Pollutant_Name.size()
	for (int pollutant_ID = 0; pollutant_ID < input->Pollutant_Name.size(); pollutant_ID++) {
		//Create string to represent variable associated with Pollutant_Name
		Name_Load_Catchment_Pollutant_Median_kg = "Load_Catchment_" + input->Pollutant_Name[pollutant_ID] + "_Median_kg";
		Name_Load_Catchment_Pollutant_Mean_kg = "Load_Catchment_" + input->Pollutant_Name[pollutant_ID] + "_Mean_kg";

		//Load_Catchment_Pollutant_Median_kg (kg) has load appended as product of Runoff_Overland_L (L), Pollutant_ConcentrationMedian_mg_p_L (mg/L), and Ratio_kg_to_mg
		Load_Catchment_Pollutant_Median_kg = (Runoff_Overland_L * input->Pollutant_ConcentrationMedian_mg_p_L[pollutant_ID] * Ratio_kg_to_mg);
		//Load_Catchment_Pollutant_Mean_kg (kg) has load appended as product of Runoff_Overland_L (L), Pollutant_ConcentrationMean_mg_p_L (mg/L), and Ratio_kg_to_mg
		Load_Catchment_Pollutant_Mean_kg = (Runoff_Overland_L * input->Pollutant_ConcentrationMean_mg_p_L[pollutant_ID] * Ratio_kg_to_mg);
		//folder->VarDict[] variable created based on string Load_Catchment_Pollutant_Median_kg, containing value Pollutant_Load_Median_kg (kg)
		folder->VarDict[Name_Load_Catchment_Pollutant_Median_kg] = Load_Catchment_Pollutant_Median_kg;
		//folder->VarDict[] variable created based on string Load_Catchment_Pollutant_Mean_kg, containing value Pollutant_Load_Mean_kg (kg)
		folder->VarDict[Name_Load_Catchment_Pollutant_Mean_kg] = Load_Catchment_Pollutant_Mean_kg;
	}
}