#ifndef NODE_H
#define NODE_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
* Author: Sanyam Chaudhary with ideas from Help_Node code provided by Professor Jim Fawcett
*/
#include<iostream>
#include<vector>
#include<string>
using namespace std;
class Node{
private:
	bool visited;
	string Nodetype;
	string NodeName;//Applies in case, the Node type is element
	vector<Node *> Children;
	vector<pair<string,string>> Attributes;
public:
     Node();
	Node(string NodeType,string NodeName);
	~Node();
	bool& isVisited();  //this will enable isVisited to behave like a property.
	void setNodeName(string);
	string getNodeName();
	void setNodetype(string);
	string getNodetype();
	Node * NextUnmarkedChild();
	Node * GetChild(int);
	bool RemoveChild(int);
	void AddChild(Node *);
	int CountChildren();		
	void AddAttributes(string,string);
	void ShowAttributes();
	void AddTextBody(string Body);
	void DisplayNode();
	pair<string,string> GetAttributes(int index);
	int CountAttributes();
	Node* getChildByTagName(string tagName);
};

#endif 

