#ifndef TREE_H
#define TREE_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
* Author: Sanyam Chaudhary with ideas from Help_Node code provided by Professor Jim Fawcett
*/
#include <unordered_map>
#include "Node.h"
#include <algorithm>
#include <map>

class Tree{
private:
	Node * root;
	vector<Node *> nodes;
	vector<Node *> Elements;
	Node * NodeWithId;
public:
	// Constructor to initialize member variables
	Tree() : root(nullptr), NodeWithId(nullptr) {
	}

	// Destructor to clean up dynamically allocated memory
	~Tree() {
		ClearNodes(); // Ensure all nodes are properly deleted
	}
	void WalkTree(Node *);
	void WalkTree(Node *, unordered_map<string, string>&);
	void WalkTree(Node *, unordered_map<string, double>&);
	void WalkTree(Node *, unordered_map<string, double>&, unordered_map<string, string>&);
	void WalkTree(Node * pParent, vector<vector<unordered_map<string, double> > > &vofomaps, vector<vector<unordered_map<string, string> > > &vofomapstring);
	void ClearNodes();
	Node * GetRoot();
	void Remove(Node*);
	void DisplayTree(Node *);
	void ClearMarks();
	void setRoot(Node *);
	vector<Node *> GetElementByTagName(string );
	void RemoveElement(string );
	void RemoveChild(Node * pChild);
	Node * GetElementById(string value);
	void AddChild(string TagName, Node *parent);
	bool equalsIgnoreCase(const string& a, const string& b);
};

#endif
