#ifndef XML_PARTS_H
#define XML_PARTS_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
* Author: Professor Jim Fawcett, CST 4-187, Syracuse University, jfawcett@twcny.rr.com
*/
/*
  Module Operations: 
  ==================
  This module defines an XML_Parts class.  Its instances build a sequence of tokens obtained from the Tokenizer module for analysis of XML.
  XmlElementParts are lists of tokens that terminate on one of the tokens
*/
#include <string>
#include <iostream>
#include <fstream>
#include <vector>
#include "Tokenizer.h"

//using namespace std allows for use of standard namespace without the preface 
using namespace std;

class XML_Parts
{
public:
  XML_Parts(Toker* pTokr);
  ~XML_Parts();
  bool get();
  int length();
  string& operator[](int n);
  int find_token(const string& tok);
  void push_back(const string& tok);
  bool remove(const string& tok);
  void toLower();
  void trimFront();
  void clear();
  string show();
  void verbose(bool v = true);

private:
  Toker* pToker;
  vector<string> toks;
  bool isTerminator(string tok);
  bool Verbose;
};

inline int XML_Parts::length() { return (int)toks.size(); }

inline void XML_Parts::verbose(bool v) { Verbose = v; }

inline void XML_Parts::clear() { toks.clear(); }

inline void XML_Parts::push_back(const string& tok)
{
  toks.push_back(tok);
}

#endif
