#ifndef BufferDynamicCalc_H
#define BufferDynamicCalc_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include "../Inputs/Inputs.h"
#include "../DataFolder.h"
#include <vector>
#include <iostream>
#include <numeric>
#include <string>
#include <algorithm>

#define Ratio_ha_to_m2 1/10000.0


class BufferDynamicCalc
{
public:
	//data rececord is matched with year record e.g. input data row: 1 1 [1993] [5]
	static void YearAverage(Inputs* input);
	static vector< vector<double> > pollutant_landcover_list;

private:
	static double quantile(const std::vector<double>& datavector, double percentile, Inputs* input);
	static double EmpericalCumulativeDistributionFunction_calc(double eventdata, Inputs* input);
	static void Interpolation(Inputs* input);
	static double LCEventload(const std::vector<double>& Landuse_EC_vectors, double Eventdata, double cell_num, Inputs* input);
};

#endif