#ifndef CreateFile_IDF_H
#define CreateFile_IDF_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include <iostream>
#include <fstream>
#include <vector>
#include <string>
#define _USE_MATH_DEFINES
#include <cmath>
#include <math.h>
#include <stdio.h>
#include <iomanip>
#include <map>
#include "../Inputs/Inputs.h"
#include "../Inputs/WeatherProcessor.h"

//treeParameters struct to hold tree variables defined
struct treeParameters {
	double Tree_Trunk_X_m;
	double Tree_Trunk_Y_m;
	double Tree_Diameter_atBH_m;
	double Tree_Canopy_Base_Height_m;
	double Tree_Canopy_Top_Height_m;
	double Tree_Canopy_Diameter_m;
	//Tree_Canopy_Shape_Option: 1=Cone, 2=Collumn, 3=Ellipsoid
	int Tree_Canopy_Shape_Option;
};

//buildingMaterial struct to hold building material variables defined
struct buildingMaterial {
	string name;
	string roughness;
	double thickness_m;
	double conductivity_W_per_mK;
	double density_kg_per_m3;
	double specific_heat_J_per_kgK;
};

//buildingMaterialNoMass struct to hold building material no mass variables defined
struct buildingMaterialNoMass {
	string name;
	string roughness;
	double thermal_resistance_m2K_per_W;
	double thermal_absorptance_frac;
	double solar_absorptance_frac;
	double visible_absorptance_frac;
};

//buildingMaterialAirGap struct to hold building material air gap variables defined
struct buildingMaterialAirGap {
	string name;
	double thermal_resistance_m2K_per_W;
};

//windowMaterialGlazing struct to hold building material glazing variables defined
struct windowMaterialGlazing {
	string name;
	string optical_data_type;
	string window_glass_spectral_data_set_name;
	double thickness_m;
	double solar_transmittance;
	double front_side_solar_reflectance;
	double back_side_solar_reflectance;
	double visible_transmittance;
	double front_side_visible_reflectance;
	double back_side_visible_reflectance;
	double infrared_transmittance;
	double front_side_infrared_emissivity;
	double back_side_infrared_emissivity;
	double conductivity_W_per_mK;
};

//windowMaterialGas struct to hold building material variables defined
struct windowMaterialGas {
	string name;
	string gas_type;
	double thickness_m;
};

//buildingConstruction struct to hold building construction variables defined
struct buildingConstruction {
	string name;
	vector<string> layers;
};

//idfOutputVariables struct to hold IDF output variables defined
struct idfOutputVariables {
	string key_value;
	string variable_name;
	string reporting_freq;
};

//idfVertex struct to hold building vertices defined
struct idfVertex {
	double x, y, z;
};

//vector<idfVertex> calculateBuildingVertices function declared
vector<idfVertex> calculateBuildingVertices(int numVertices, double lowerLeft_X_m, double lowerLeft_Y_m, double assembly_delta_X_m, double assembly_delta_Y_m, double floor_delta_X_m, double floor_delta_Y_m, double roof_delta_X_m, double roof_delta_Y_m, double height_min_m, int AssemblyFace_azimuth, bool isGable, double height_max_m, double height_roof_m);

//vector<idfVertex> calculateTreeVertices function declared
vector<idfVertex> calculateTreeVertices(const treeParameters& params, int wedgePart, int segmentNumber, int numSegments);

//assemblyGeometry struct to hold building vertice as varaibles defined
struct assemblyGeometry {
	double lowerLeft_X_m;
	double lowerLeft_Y_m;
	double assembly_delta_X_m;
	double assembly_delta_Y_m;
	double roof_delta_X_m;
	double roof_delta_Y_m;
	double window_delta_X_m;
	double window_delta_Y_m;
};

//assemblyGeometry struct calculateAssemblyGeometry function declared
assemblyGeometry calculateAssemblyGeometry(int i, double Wall_Reference_Length_XCoordinate_m, double Wall_NonReference_Length_YCoordinate_m, double Window_LeftEdge_m, double Window_Length_m);


class CreateFile_IDF
{
public:

	//Create_IDF_file function to create IDF, EnergyPlus input data file
	void Create_IDF_file(Inputs* input, string scenarioCoolBuilding);
	//ErrorCheck_CoolBuilding_parameters funtion to check HydroPlusConfig.xml parameter values
	void ErrorCheck_CoolBuilding_parameters(Inputs* input);
	//writeBuildingSurface function to create IDF section for BuildingSurface and FenestrationSurface
	void writeBuildingSurface(ofstream& file, const string Heading_Subsection_str, const string& assemblyName, const string& surfaceType, const string& constructionType, string outsideBoundaryCondition, string buildingSurfaceName, double viewFactorGround, string sunExposed, string windExposed, const vector<idfVertex>& vertices);
	//writeTreeSurface function to create IDF section for Shading:Building
	void writeTreeSurface(ofstream& outputFile_IDF, const string& treeName, const string& transmittanceSchedule, const vector<idfVertex>& vertices);
	//writeContentAndComments function to format IDF text as content inputs and comments following !-
	void writeContentAndComments(ofstream& outputFile_IDF, const vector<string>& content, const vector<string>& comment);

};

#endif