#ifndef DataFolder_H
#define DataFolder_H
#include <unordered_map>
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include <map>
#include <string>
#include <vector>
#include <initializer_list>
using namespace std;

//Refactor Considered:
//Problem: Cool Air will not complete a simulation when the map arrays are approximately larger than 300 x 300 pixels. Given that many urban areas are larger than this size limit when using 900 m2 pixels, the model needs to be run across several sub-area quads, which requires additional model management. The limit on model array size seems to be computer memory (RAM), where many model variables are assigned to unique pixel or folder instances (e.g., folder->), using the DataOrganizer DataDrawers constructor. The constraint likely emerges in this function BuildDataOrganizer::Folder_CoverData_Statistical.
//Solution: For SpatialTemperatureHydro model runs, it may be possible to avoid using any or many folder variables and simply access variables as raw input(e.g., input->) or computed derivatives of raw input.Folders seem very useful when working with StatisticalHydro model runs and having a folder for BulkAreaand a folder for GI type.Having a folder for each map pixel seems to burden the RAM.
//Solution: David Ellington of Davey Tree suggest replacing our static string dictionaries with objects or structures that have named properties, e.g., folder->ParamDict["TreeCover_frac"] replaced with LandCover.TreeCover.AreaFraction

//DataFolder structure created with a set of data types
struct DataFolder
{
	unordered_map<string, double> ParamDict;
	unordered_map<string, string> ParamStringDict;
	unordered_map<string, double> VarDict;
	unordered_map<string, vector<double> > VarVecDict;
};

#endif


