#ifndef PotentialEvaporationCalc_H
#define PotentialEvaporationCalc_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include "../Inputs/Inputs.h"
#include "../DataFolder.h"
//include "HeatMetrics_Calc.h" to access HeatMetrics_Calc.cpp functionality 
#include "../CoolAir/HeatMetrics_Calc.h"

//Referemces:
//Chin, D. A. (2021). Water Resources Engineering, Fourth Edition. Hoboken, NJ: Pearson Education.
//Thom, A. S., & Oliver, H. R. (1977). On Penman's equation for estimating regional evaporation. Quarterly Journal of the Royal Meteorological Society, 103(436), 345-357. doi:https://doi.org/10.1002/qj.49710343610

//Constant Latent heat of vaporization (J/kg)
#define LatentHeatVaporization_J_p_kg 2257000.0 
//Constant for computing saturated vapor pressure (kPa)
#define Constant_0_p_6108_kPa 0.6108
//Constant for convert degrees F to C 
#define Constant_5_d_9 5.0/9.0
//Constant for convert degrees F to C 
#define Constant_32_F 32.0
//Constant von Karman number; Range of values reported in research, recently tending towward 0.4
#define vonKarman_Constant 0.41
//Constant SpecificHeat_MoistAir_J_p_kg_p_C is specific heat of moist air at constant pressure, defined by Chin (2021) w Eq 13.37
#define SpecificHeat_MoistAir_J_p_kg_p_C 1013

//Ratio_MolecularWeightVapor_to_MolecularWeightDryAir is ratio of molecular weight for water vapor to dry air
#define Ratio_MolecularWeightVapor_to_MolecularWeightDryAir 0.622
//Ratio of seconds to hour
#define Ratio_sec_to_hr 3600.0
//Ratio of hour to seconds
#define Ratio_hr_to_sec 1.0/3600.0
//Ratio of Pascall to kiloPascall
#define Ratio_Pa_to_kPa 1000.0
//Ratio of Joules to megaJoules
#define Ratio_J_to_MJ 1000000.0
//Ratio of megaJoules to Joules
#define Ratio_MJ_to_J 1.0 / 1000000.0

//ZeroPlaneDisplacementHeight_frac (fraction) from Eq 13.3 Chin (2021) adjusts cover height to get zero plane displacement height
#define ZeroPlaneDisplacementHeight_frac 0.67
//Zom_RoughnessLengthMomentumTransferCoefficient roughness length coefficient controlling momentum transfer defined Eq 13.3 Chin (2021)
#define Zom_RoughnessLengthMomentumTransferCoefficient 0.123
//Zom_RoughnessLengthHeatVaporTransferCoefficient roughness length coefficient controlling heat and vapor transfer defined Eq 13.4 and following text Chin (2021)
#define Zom_RoughnessLengthHeatVaporTransferCoefficient 0.0123
//roughness length (m) for classification open, e.g. airport, from Davenport-Wieringa classification, from Table 4.1 in Stull (2000)
#define RoughnessLength_Airport_m 0.03
//RoughnessLength_Water_m = 0.00137 m, based on roughness length (m) for water set to z0 = 0.00137 m Chin (2021) and Thom and Oliver (1977)
//Note: Chin, D. A. (2021). Water Resources Engineering, Fourth Edition. Hoboken, NJ: Pearson Education.
//Note: Thom, A. S., & Oliver, H. R. (1977). On Penman's equation for estimating regional evaporation. Quarterly Journal of the Royal Meteorological Society, 103(436), 345-357. doi:https://doi.org/10.1002/qj.49710343610
#define RoughnessLength_Water_m 0.00137
//Roughness Lengths from Davenport-Wieringa Zo (m) to Classification and Landscape Table 4.1 in Stull (2000)
//Note: Classification smooth = Snow; Classification Open = Airport; Note UCAR Community Land Model uses 0.024 
#define RoughnessLength_Snow_m 0.005
//RoughnessLength_Soil_m = 0.007 m, based on slightly rougher classification smooth, e.g. beaches, morass, from Davenport-Wieringa classification, from Table 4.1 in Stull (2000)
//Note: Set to 0.007 m, modified to be rougher than smooth
#define RoughnessLength_Soil_m 0.007
//RoughnessLength_SVeg_m = 0.03, based on classification open, e.g. grass prarie or farm field, from Davenport-Wieringa classification, from Table 4.1 in Stull (2000)
#define RoughnessLength_SVeg_m 0.03
//RoughnessLength_Tree_m = 0.25 m + 0.75 * Tree_frac, function based on classification rough to closed, e.g. scattered trees to mature forest, from Davenport-Wieringa classification, from Table 4.1 in Stull (2000)
#define RoughnessLength_Tree_m 0.25

//Ratio of vapor to momentum roughness lengths from Jensen and Allen (2015) Chapter 11, citing Garratt and Hicks (1973)
//Ratio of vapor to momentum roughness lengths for short grass or herbaceous
#define Ratio_Herbaceous_Zov_to_Zom 0.08
//Ratio of vapor to momentum roughness lengths for short vegetation or shrub
#define Ratio_Shrub_Zov_to_Zom 0.14
//Ratio of vapor to momentum roughness lengths for tree or forest
#define Ratio_Tree_Zov_to_Zom 0.35
//Ratio of vapor to momentum roughness lengths for water
#define Ratio_Water_Zov_to_Zom 1.0

class PotentialEvaporationCalc 
{
	public:
		static void Method_PenmanMonteith(Inputs *input, WeatherProcessor* WeatherPro, DataFolder *folder, int timeStep);
};



#endif