#ifndef FlowRouteCalc_H
#define FlowRouteCalc_H
//////////////////////////////////////////////////////////////////////////////////
//																		        //
// FlowRouteCalc.h - Routes the total runoff/streamflow of the catchment    //
//                       for one time step                                      //																		   
// ver 1.0                                                                      //
// Language:    Visual C++ 2010                                                 //
// Platform:    MacBookPro5,4  Win7										        //
// Application: HydroPrime/iHydro Version6, Summer 2012-15                      //
// Programmer:   				        //
//              Thomas P. Taggart, traggatmot@gmail.com                         //
//////////////////////////////////////////////////////////////////////////////////
/*
Origin:
==================
Program: iHydro Version 5

Source Code File(s): comChannel.cpp Function: (line 336) runoff(int IT, double BQ, double OFQ, double UrQ, int NSTEP);

Author(s): Jun Wang, jwang06@mailbox.syr.edu, Original author
 
Thomas P. Taggart, traggatmot@gmail.com
*Incorporated calculation into new architecture
Creation Date: Summer 2000

Publication(s): Jun Wang PHDThesis, Tom Taggart PhD Thesis

Module Operations:
==================
...

Public Interface:
=================


Build Process:
==============
Required files
-IProcess.h, InputsRepository.h, Runoff.cpp

Build commands
- devenv hydroprime.sln

Maintenance History:
====================

*/



#include "../Inputs/Inputs.h"
#include "../DataFolder.h"
#include <vector>
#include <iostream>
#include <numeric>
#include <string>
#include <functional>

//Conversion hour to seconds
#define ratio_hr_to_s 1.0/3600.0

class FlowRouteCalc
{
public:

	static void calculateStatistical(Inputs *input, int timeStep);
};



#endif