#ifndef Flux_Manager_StormwaterDevice_H
#define Flux_Manager_StormwaterDevice_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include "../Inputs/Inputs.h"
#include "../DataFolder.h"

//Define constants effective maximum 
#define Constant_1E_positive10 1.E10
//Define constant effective zero value
#define Constant_1E_negative10 1.E-10     
//Flux_GI_Minimum_m_p_s defined as minimum water flux worth tracking; EPA SWMM used 0.001 in/hr; we use 0.001 mm/hr which is converted below to m/sec
#define Flux_GI_Minimum_m_p_s 2.8E-10        
// Value for TRUE state
#define TRUE 1              
// Value for FALSE state
#define FALSE 0              
//Conversion seconds to hour
#define Ratio_s_to_hr 3600
//Conversion hour to seconds
#define Ratio_Hour_to_Second 1.0/3600.0
//Conversion hour to day
#define Ratio_Hour_to_Day 24
//Conversion meters to feet
#define Ratio_m_to_ft 0.3048
//Conversion m to mm
#define Ratio_m_to_mm 1.0/1000.0
//Conversion mm to m
#define Ratio_mm_to_m 1000.0


//MIN function for finding minimum of x_var and y_var using conditional ternary operator (?:)
//Note: Ternary operator explained: For (x_var<=y_var?x_var:y_var), if x_var<=y_var is true, then x_var is taken, otherwise y_var taken.
#define MIN(x_var,y_var) (((x_var)<=(y_var)) ? (x_var) : (y_var))        
//MAX function for finding minimum of x_var and y_var using conditional ternary operator (?:)
//Note: Ternary operator explained: For (x_var<=y_var?x_var:y_var), if x_var<=y_var is true, then x_var is taken, otherwise y_var taken.
#define MAX(x_var,y_var) (((x_var)>=(y_var)) ? (x_var) : (y_var))        

class Flux_Manager_StormwaterDevice {
public:

	//Calculate function organizes the inflows to the GI devices
	static void Calculate(Inputs* input, DataFolder* folder,
		std::map<std::string, void(*)(Inputs* input, DataFolder* folder, int timeStep) >& functors, int timeStep);

	//GI_Flux_Layer_Sequencer function coordinates flux rates for all GI Types
	static void GI_Flux_Layer_Sequencer(Inputs* input, DataFolder* folder,
		std::map<std::string, void(*)(Inputs* input, DataFolder* folder, int timeStep) >& functors, int timeStep);

	static void GI_Flux_Storage_Balancer(DataFolder* folder, int timeStep);

};

#endif