#include "Leave_GI_Device.h"

//Leave_GI_Device::CollectVariables function organizes the storage and flux variables for the GI devices
void Leave_GI_Device::CollectVariables(Inputs* input, DataFolder* folder, int timeStep)
{
	//Total_Drainage_GI_Pavement_m3 (m3) is increased by Percolation_Pavement_m3 (m3)
	folder->VarDict["Total_Drainage_GI_Pavement_m3"] = folder->VarDict["Total_Drainage_GI_Pavement_m3"] + folder->VarDict["Percolation_Pavement_m3"];
	//Total_GI_Drainage_VadoseZone_m3 (m3) increased each timeStep by with Drainage_VadoseZone_m3 (m3) 
	folder->VarDict["Total_GI_Drainage_VadoseZone_m3"] = folder->VarDict["Total_GI_Drainage_VadoseZone_m3"] + folder->VarDict["Drainage_VadoseZone_m3"];

	//Infiltration_m (m) as pervious area depth derived from Infiltration_Surface_m3 (m3), updated in GI_Flux_Storage_Balancer function, dividing with ...
	//Note: ... Area_GI_Unit_Pervious_m2 (m2) and multiplying by (1 - Soil_Macropore_frac) to get fraction not going to macropores
	folder->VarDict["Infiltration_m"] = (folder->VarDict["Infiltration_Surface_m3"] / folder->VarDict["Area_GI_Unit_Pervious_m2"]) * (1 - folder->ParamDict["Soil_Macropore_frac"]);
	//Drainage_macroPore_m (m) as pervious area depth derived from Infiltration_Surface_m3 (m3), updated in GI_Flux_Storage_Balancer function, dividing with ...
	//Note: ... Area_GI_Unit_Pervious_m2 (m2) and multiplying by Soil_Macropore_frac to get fraction going to macropores
	//Note: Infiltration_Surface_m3 (m3) includes Drainage_macroPore_m for GI device vertical balance
	folder->VarDict["Drainage_macroPore_m"] = (folder->VarDict["Infiltration_Surface_m3"] / folder->VarDict["Area_GI_Unit_Pervious_m2"]) * folder->ParamDict["Soil_Macropore_frac"];
	//Infiltration_viaSatEx_m (m) recomputed w Infiltration_m (m) and InfiltExcessGovernedArea_frac 
	folder->VarDict["Infiltration_viaSatEx_m"] = folder->VarDict["Infiltration_m"] * (1 - folder->ParamDict["InfiltExcessGovernedArea_frac"]);
	folder->VarDict["Infiltration_viaInfilEx_m"] = folder->VarDict["Infiltration_m"] * folder->ParamDict["InfiltExcessGovernedArea_frac"];

	//Equations to scale from volume for one GI unit to volume for all GI units by Count_GI_Units
	folder->VarDict["GI_Precipitation_m3"] = folder->VarDict["Flux_to_GI_Precipitation_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_Inflow_from_BulkArea_m3"] = folder->VarDict["Flux_BulkArea_to_GI_Runon_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_Infiltration_m3"] = folder->VarDict["Infiltration_Surface_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_Drainage_PercolationPavement_m3"] = folder->VarDict["Percolation_Pavement_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_Drainage_Percolation_m3"] = folder->VarDict["Percolation_Soil_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_Drainage_Exfiltration_m3"] = folder->VarDict["Exfiltration_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_Drainage_VadoseZone_m3"] = folder->VarDict["Drainage_VadoseZone_m3"] * folder->ParamDict["Count_GI_Units"];
	//Note: Consider refactor to send to VarDict Runoff_GI_Outlet_m3 and Runoff_GI_Berm_m3 as two components of GI_Runoff_Surface_m
	folder->VarDict["GI_Runoff_Surface_m3"] = folder->VarDict["Runoff_Surface_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_Runoff_Vault_m3"] = folder->VarDict["Runoff_Vault_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_EvaporationSurface_m3"] = folder->VarDict["EvapoTrans_Surface_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_EvaporationPavement_m3"] = folder->VarDict["EvapoTrans_Pavement_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_EvaporationSoil_m3"] = folder->VarDict["EvapoTrans_Soil_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_EvaporationVault_m3"] = folder->VarDict["EvapoTrans_Vault_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_EvaporationAllLayers_m3"] = folder->VarDict["EvapoTranspiration_GI_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_Storage_SurfaceLayer_m3"] = folder->VarDict["Storage_GI_Surface_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_Storage_PavementLayer_m3"] = folder->VarDict["Storage_GI_Pavement_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_Storage_SoilLayer_m3"] = folder->VarDict["Storage_GI_Soil_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_Storage_VaultLayer_m3"] = folder->VarDict["Storage_GI_Vault_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_Storage_GroundwaterMound_m3"] = folder->VarDict["Storage_GroundwaterMound_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_Storage_GI_Pavement_Max_Potential_m3"] = folder->VarDict["Storage_GI_Pavement_Max_Potential_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_Storage_GI_Pavement_Max_m3"] = folder->VarDict["Storage_GI_Pavement_Max_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_Storage_GI_Soil_Max_Potential_m3"] = folder->VarDict["Storage_GI_Soil_Max_Potential_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_Storage_GI_Soil_Max_m3"] = folder->VarDict["Storage_GI_Soil_Max_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_Storage_GI_Vault_Max_Potential_m3"] = folder->VarDict["Storage_GI_Vault_Max_Potential_m3"] * folder->ParamDict["Count_GI_Units"];
	folder->VarDict["GI_Storage_GI_Vault_Max_m3"] = folder->VarDict["Storage_GI_Vault_Max_m3"] * folder->ParamDict["Count_GI_Units"];

	double Folder_Pervious_Area_m2 = folder->ParamDict["Area_m2"] * folder->ParamDict["PerviousCover_frac"];
	folder->VarDict["Drainage_VadoseZone_m"] = 0;
	folder->VarDict["Drainage_SoilEvapZone_m"] = 0;
	//If Folder_Pervious_Area_m2 > 0 then enter and divide by Folder_Pervious_Area_m2
	if (Folder_Pervious_Area_m2 > 0) {
		//Drainage_VadoseZone_m (m) generated as pervious cover depth by dividing GI_Drainage_VadoseZone_m3 (m3) by Folder_Pervious_Area_m2 (m2)
		folder->VarDict["Drainage_VadoseZone_m"] = folder->VarDict["GI_Drainage_VadoseZone_m3"] / Folder_Pervious_Area_m2;
		//Drainage_SoilEvapZone_m (m) generated as pervious cover depth by dividing GI_Drainage_VadoseZone_m3 (m3) by Folder_Pervious_Area_m2 (m2)
		//Note: Drainage_SoilEvapZone_m (m) is maximum of GI_Drainage_Percolation_m3 (m3) and GI_Drainage_PercolationPavement_m3 (m3) divided by Folder_Pervious_Area_m2
		folder->VarDict["Drainage_SoilEvapZone_m"] = MAX(folder->VarDict["GI_Drainage_Percolation_m3"], folder->VarDict["GI_Drainage_PercolationPavement_m3"]) / Folder_Pervious_Area_m2;
	}
	//If Drainage_SoilEvapZone_m (m) is zero, then GI has no soil or pervious layer, and inflow is directly to the vault layer
	if (folder->VarDict["Drainage_SoilEvapZone_m"] <= 0) {
		//Drainage_SoilEvapZone_m (m) is equal to Drainage_VadoseZone_m (m) when vault is exposed to surface layer
		folder->VarDict["Drainage_SoilEvapZone_m"] = folder->VarDict["Drainage_VadoseZone_m"];
	}

	//Runoff_Pervious_m3 (m3) is pervious fraction of Runoff_Surface_m3, scaled from one GI unit to all GI units by Count_GI_Units, transferred to RunoffSummation
	input->RepoDict["Runoff_Pervious_m3"] = folder->VarDict["Runoff_Pervious_m3"] * folder->ParamDict["Count_GI_Units"];
	//Runoff_Impervious_m3 (m3) is impervious fraction of Runoff_Surface_m3, scaled from one GI unit to all GI units by Count_GI_Units, transferred to RunoffSummation
	input->RepoDict["Runoff_Impervious_m3"] = folder->VarDict["Runoff_Impervious_m3"] * folder->ParamDict["Count_GI_Units"];
	//Runoff_Water_m3 (m3) is water cover fraction of Runoff_Surface_m3, scaled from one GI unit to all GI units by Count_GI_Units, transferred to RunoffSummation
	input->RepoDict["Runoff_Water_m3"] = folder->VarDict["Runoff_Water_m3"] * folder->ParamDict["Count_GI_Units"];
	//Runoff_Vault_m3 (m3) is Runoff_Vault_m3 from pervious or impervius vault layer, scaled from one GI unit to all GI units by Count_GI_Units, transferred to RunoffSummation
	input->RepoDict["Runoff_Vault_m3"] = folder->VarDict["Runoff_Vault_m3"] * folder->ParamDict["Count_GI_Units"];

	//GI Variables as depths (m) constructed
	//GI water volumes (m3) scaled to folder area depths (m) by division with Area_per_GIUnit_m2; equivalent to GI device depth given volume is for device
	folder->VarDict["GI_Precipitation_m"] = folder->VarDict["Flux_to_GI_Precipitation_m3"] / folder->VarDict["Area_GI_Unit_m2"];
	folder->VarDict["GI_Inflow_m"] = folder->VarDict["Flux_BulkArea_to_GI_Runon_m3"] / folder->VarDict["Area_GI_Unit_m2"];
	folder->VarDict["GI_Infiltration_m"] = folder->VarDict["Infiltration_Surface_m3"] / folder->VarDict["Area_GI_Unit_m2"];
	folder->VarDict["GI_Drainage_PercolationPavement_m"] = folder->VarDict["Percolation_Pavement_m3"] / folder->VarDict["Area_GI_Unit_m2"];
	folder->VarDict["GI_Drainage_Percolation_m"] = folder->VarDict["Percolation_Soil_m3"] / folder->VarDict["Area_GI_Unit_m2"];
	folder->VarDict["GI_Drainage_Exfiltration_m"] = folder->VarDict["Exfiltration_m3"] / folder->VarDict["Area_GI_Unit_m2"];

	//Note: Consider refactor to use Runoff_Pervious_m3 to define Runoff_SatExcess_m and Runoff_InfilExcess_m
	//Note: Consider refactor to send to VarDict Runoff_GI_Outlet_m3 and Runoff_GI_Berm_m3 as two components of GI_Runoff_Surface_m
	folder->VarDict["GI_Runoff_Surface_m"] = folder->VarDict["Runoff_Surface_m3"] / folder->VarDict["Area_GI_Unit_m2"];
	folder->VarDict["GI_Runoff_Vault_m"] = folder->VarDict["Runoff_Vault_m3"] / folder->VarDict["Area_GI_Unit_m2"];
	folder->VarDict["GI_EvaporationSurface_m"] = folder->VarDict["EvapoTrans_Surface_m3"] / folder->VarDict["Area_GI_Unit_m2"];
	folder->VarDict["GI_EvaporationPavement_m"] = folder->VarDict["EvapoTrans_Pavement_m3"] / folder->VarDict["Area_GI_Unit_m2"];
	folder->VarDict["GI_EvaporationSoil_m"] = folder->VarDict["EvapoTrans_Soil_m3"] / folder->VarDict["Area_GI_Unit_m2"];
	folder->VarDict["GI_EvaporationVault_m"] = folder->VarDict["EvapoTrans_Vault_m3"] / folder->VarDict["Area_GI_Unit_m2"];
	folder->VarDict["GI_EvaporationAllLayers_m"] = folder->VarDict["EvapoTranspiration_GI_m3"] / folder->VarDict["Area_GI_Unit_m2"];
	folder->VarDict["GI_Storage_PavementLayer_m"] = folder->VarDict["Storage_GI_Pavement_m3"] / folder->VarDict["Area_GI_Unit_m2"];
	folder->VarDict["GI_Storage_SurfaceLayer_m"] = folder->VarDict["Storage_GI_Surface_m3"] / folder->VarDict["Area_GI_Unit_m2"];
	folder->VarDict["GI_Storage_SoilLayer_m"] = folder->VarDict["Storage_GI_Soil_m3"] / folder->VarDict["Area_GI_Unit_m2"];
	folder->VarDict["GI_Storage_VaultLayer_m"] = folder->VarDict["Storage_GI_Vault_m3"] / folder->VarDict["Area_GI_Unit_m2"];
}