#ifndef Leave_GI_Device_H
#define Leave_GI_Device_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include "../Inputs/Inputs.h"
#include "../DataFolder.h"

//Define constants effective maximum 
#define Constant_1E_positive10 1.E10
//Define constant effective zero value
#define Constant_1E_negative10 1.E-10

//MIN function for finding minimum of x_var and y_var using conditional ternary operator (?:)
//Note: Ternary operator explained: For (x_var<=y_var?x_var:y_var), if x_var<=y_var is true, then x_var is taken, otherwise y_var taken.
#define MIN(x_var,y_var) (((x_var)<=(y_var)) ? (x_var) : (y_var))        

//MAX function for finding minimum of x_var and y_var using conditional ternary operator (?:)
//Note: Ternary operator explained: For (x_var<=y_var?x_var:y_var), if x_var<=y_var is true, then x_var is taken, otherwise y_var taken.
#define MAX(x_var,y_var) (((x_var)>=(y_var)) ? (x_var) : (y_var))        

class Leave_GI_Device {
public:

	//Percolation_Pavement function computes reduced permeability of a pavement layer due to clogging.
	static void CollectVariables(Inputs* input, DataFolder* folder, int timeStep);

};

#endif