#ifndef WaterBalance_Summary_H
#define WaterBalance_Summary_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include <string>
#include <vector>
#include <algorithm>
#include "calibrate.h"
#include "../Inputs/Inputs.h"
#include "../DataFolder.h"
#include <fstream>

using namespace std;

//Conversion hour to seconds
#define Ratio_Hour_to_Second 1.0/3600.0
//Conversion mm to m
#define Ratio_mm_to_m 1000.0
//Conversion fraction to percent
#define Ratio_Decimal_to_Percent 100.0

class WaterBalance_Summary
{
	public:
		static void writeWaterBalanceFile(Inputs* input);
		static void writeCaliQobs(Inputs *input);
		static void writeCaliTotalQQ(Inputs *input);

		static vector<double> Convert_TimeSeries_Hour_to_Day_vector(const vector<double>& input);
		static double Sum_TimeSeries_Hour_to_Day(const vector<double>& input, const int i);
		static vector<double> Convert_TimeSeries_Hour_to_Week_vector(const vector<double>& input);
		static double Sum_TimeSeries_Hour_to_Week(const vector<double>& input, const int i);
		static vector<double> Convert_TimeSeries_Hour_to_Month_vector(const vector<double>& input);
		static double Sum_TimeSeries_Hour_to_Month(const vector<double>& input, const int i);
		static vector<double> convertToTimeStep(const vector<double>& val, const string timeStep);
		static vector<int> getDailyDate(const vector<int> date);	
		static vector<int> getWeeklyDate(const vector<int> date);
		static vector<int>  getMonthlyDate(const vector<int> date);
		static double sumAcrossFolderTypes(const Inputs* input, const string& varName);
};

#endif