#ifndef WaterBalance_TimeSeries_H
#define WaterBalance_TimeSeries_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include "../Inputs/Inputs.h"
#include "../DataFolder.h"
#include "WriteOutputs.h"
#include <fstream>
#include <iomanip>
#include <iostream>

using namespace std;

//Define constant effective zero value
#define Constant_1E_negative10 1.E-10     

class WaterBalance_TimeSeries
{
public:
	//write_TimeSeries_CatchmentVariables function writes multiple output files
	static void write_TimeSeries_CatchmentVariables(Inputs* input, int timeStep);

	//writeWaterBalanceTS_GIUnit writes header for GI fluxes and storages
	static void writeWaterBalanceHeader_GIUnit(Inputs* input, int timeStep);
	//writeWaterBalanceTS_GIUnit writes time series values for GI fluxes and storages
	static void writeWaterBalanceTS_GIUnit(Inputs *input, int timeStep);

	//WaterBalance_TimeSeries::writeWeatherDriversAndPhenology function will write weather variables and LAI time series
	static void writeWeatherDriversAndPhenology(Inputs* input, int timeStep);

	//openFiles_WaterBalanceTimeSeries opens files for output
	static void openFiles_WaterBalanceTimeSeries(Inputs* input, int Folder_List_size, int Folder_Type_ID, string Name_Folder_Type_str, vector<ofstream>& outfile_CanopyVariables_m,
		vector<ofstream>& outfile_CanopyVariables_m3, vector<ofstream>& outfile_PerviousCoverVariables_m, vector<ofstream>& outfile_PerviousCoverVariables_m3,
		vector<ofstream>& outfile_ImperviousCoverVariables_m, vector<ofstream>& outfile_ImperviousCoverVariables_m3, vector<ofstream>& outfile_TreeCoverVariables_m,
		vector<ofstream>& outfile_TreeCoverVariables_m3, vector<ofstream>& outfile_RunoffVariables_m, vector<ofstream>& outfile_RunoffVariables_m3);
};
#endif
