#include "Flux_to_Water.h"
#include <iostream>

//Note: Function could be simplified to remove multiplication followed by division, yet these steps allow elaboration of water cover types as in FluxToImpervious and FluxToPervious
void Flux_to_Water::calculate(Inputs *input, DataFolder *folder, int timeStep)
{
	//Note: Multiplication of variables by fractional area below is to adjust depths from one analysis area to entire folder area
	//Rationale: 1. variables arrive as depths for an analysis area (e.g., pervious area)
	//Rationale: 2. multiplying these depths by their analysis area gives a volume, which is conserved when transfered between different areas
	//Rationale: 3. multiplying these depths by their fractional area is equivalent to multiplying by their analysis area and dividing by the folder area, getting depth for folder area
	//Note: Multiplication is equivalent to multiplying by ratio of analysis area to folder area to convert from /analysis_area to /folder_area

	//Note: Division of variables by fractional area below is to adjust depths from entire folder area to one analysis area
	//Rationale: 1. variables arrive as depths for the entire folder area
	//Rationale: 2. multiplying these depths by the folder area gives a volume
	//Rationale: 3. dividing these depths by the analysis area is equivalent to multiplying by the folder area and dividing by the analysis area, getting depth for analysis area
	//Note: Division is equivalent to multiplying by ratio of folder area to analysis area to convert from /folder_area to /analysis_area

	//Flux_to_WaterArea_Rain_SnowMelt_m (m) accumulates precipitation flux on water cover
    //Flux_to_WaterArea_Rain_SnowMelt_m (m) is folder area depth and equals Precipitation_RainSnowMelt_noCanopy_m (m) * WaterCover_noTreeCanopy_frac (fraction)
    //Note: Precipitation_RainSnowMelt_noCanopy_m (m) is cover area depth, multiplying by WaterCover_noTreeCanopy_frac (fraction) converts to folder area depth
    folder->VarDict["Flux_to_WaterArea_Rain_SnowMelt_m"] = folder->VarDict["Precipitation_RainSnowMelt_noCanopy_m"] * folder->ParamDict["WaterCover_noTreeCanopy_frac"];

	//If WaterCover_noTreeCanopy_frac > 0 then divide by WaterCover_noTreeCanopy_frac
	if (folder->ParamDict["WaterCover_noTreeCanopy_frac"] > 0) {

		//Flux_to_WaterArea_Rain_SnowMelt_m (m) arrives as folder area depth by above multiplication with Flux_to_WaterArea_Rain_SnowMelt_m
		//Flux_to_WaterArea_Rain_SnowMelt_m (m) adjusted to cover type area depth by division with Flux_to_WaterArea_Rain_SnowMelt_m
		folder->VarDict["Flux_to_WaterArea_Rain_SnowMelt_m"] = folder->VarDict["Flux_to_WaterArea_Rain_SnowMelt_m"] / folder->ParamDict["WaterCover_noTreeCanopy_frac"];

	}
	//Else avoid division by zero
	else {
		folder->VarDict["Flux_to_WaterArea_Rain_SnowMelt_m"] = 0;
	}

}
