#ifndef Removal_StormwaterPollutants_H
#define Removal_StormwaterPollutants_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include "../Inputs/Inputs.h"
#include "../DataFolder.h"
#include <fstream>
#include <iomanip>
#include <iostream>

//Conversion between cubic meter and liter
#define Ratio_m3_to_L 1.0/1000.0
//Conversion between liter and cubic meter
#define Ratio_L_to_m3 1000
//Conversion between kg and mg
#define Ratio_kg_to_mg 1.0/1000000.0
//Conversion between g and mg
#define Ratio_g_to_mg 1.0/1000.0
//Conversion between fraction and percent
#define Ratio_Decimal_to_Percent 0.01

//Function uses Pollutant.dat to obtain Pollutant_Name (TSS BOD COD TP SolP TKN NO2_3 Cu Pb Zn)
//Note: These pollutant names must equal the names used in HydroPlusConfig.xml for removal efficiencies, as the names are matched

class Removal_StormwaterPollutants
{
public:

	static void Removal(Inputs* input, DataFolder* folder);
	static void Removal_TS(Inputs* input, DataFolder* folder);
	static void Pollutant_Removal_via_GI(Inputs* input, DataFolder* folder, int timeStep);
	static void GI_WQ_Outputwriter(Inputs* input, DataFolder* folder, std::map<std::string, double>& variables);
	static void GI_WQ_Outputwriter_TS(Inputs* input, DataFolder* folder);
	static void reduce_EC_EMC_after_GI(Inputs* input, DataFolder* folder);

private:

};
#endif