#ifndef XMLDOCUMENT_H
#define XMLDOCUMENT_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
* Author: Sanyam Chaudhary with ideas from Help_Node code provided by Professor Jim Fawcett
*/
/*
  Module Operations:
  ==================
  This module is used to return a xml file/string in a tree form contained in memory
  This module defines a XML_Document class, useful in building a tree from the parsed XML tokens.
*/
#include "XML_Parts.h"
#include "WalkTree.h"
#include <stack>
class XML_Document
{
public:

	Node * Load(std::string, bool isFile);
	void CreateNode(Node *, XML_Parts);
	std::string ShowComment(XML_Parts &parts);
	Node * ParseString(std::string XMLstring);

private:
	stack<Node*> ScopeStack;
	Node * Document;
	
};

#endif
