﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Data.OleDb;
using System.Xml;
using System.IO;
using UFORE.Location;
using UFORE.LAI;
using UFORE.Weather;
// testing - rc 3/19/2021
namespace WeatherPrep
{
    class ReamXML
    {

        static void Main(string[] args)
        {
            VEGTYPE vegType;
            using (XmlReader reader = XmlReader.Create(@"c:\Users\zjack\Downloads\WeatherDataExtractorConfig.xml"))
            {
                while (reader.Read())
                {
                    if (reader.IsStartElement())
                    {
                        //return only when you have START tag  
                        switch (reader.Name.ToString())
                        {
                            case "LocalDataBase":
                                String LocalDataBase = reader.ReadString();
                                Console.WriteLine(LocalDataBase);
                                int ordNation, ordNationID;
                                break;
                            case "Country":
                                String Country = reader.ReadString();
                                Console.WriteLine(Country);
                                break;
                            case "State":
                                String State = reader.ReadString();
                                Console.WriteLine(State);
                                break;
                            case "County":
                                String County = reader.ReadString();
                                Console.WriteLine(County);
                                break;
                            case "City":
                                String City = reader.ReadString();
                                Console.WriteLine(City);
                                break;
                            case "MaximumLAI":
                                int MaximumLAI = Int32.Parse(reader.ReadString());
                                Console.WriteLine(MaximumLAI);
                                break;
                            case "EvergreenPercent":
                                int EvergreenPercent = Int32.Parse(reader.ReadString());
                                Console.WriteLine(EvergreenPercent);
                                break;
                            case "LAIDatabase":
                                String LAIDatabase = reader.ReadString();
                                Console.WriteLine(LAIDatabase);
                                break;
                            case "StartYear":
                                int StartYear = Int32.Parse(reader.ReadString());
                                Console.WriteLine(StartYear);
                                break;
                            case "VegetationType":
                                String VegetationType = reader.ReadString();
                                if (VegetationType.Equals("Tree"))
                                {
                                    vegType = VEGTYPE.TREE;
                                }
                                else if (VegetationType.Equals("Shrub"))
                                {
                                    vegType = VEGTYPE.SHRUB;
                                }
                                else if (VegetationType.Equals("Grass"))
                                {
                                    vegType = VEGTYPE.GRASS;
                                }
                                else
                                {
                                    // runInput = false;
                                    Console.WriteLine("Error: Invalid vegetation type");
                                }

                                Console.WriteLine(VegetationType);
                                break;
                            case "SurfaceWeatherDataFile":
                                String SurfaceWeatherDataFile = reader.ReadString();
                                Console.WriteLine(SurfaceWeatherDataFile);
                                break;
                            case "RainDataExcel":
                                String RainDataExcel = reader.ReadString();
                                Console.WriteLine(RainDataExcel);
                                break;
                            case "WeatherDatabase":
                                String WeatherDatabase = reader.ReadString();
                                Console.WriteLine(WeatherDatabase);
                                break;
                            case "EndYear":
                                int EndYear = Int32.Parse(reader.ReadString());
                                Console.WriteLine(EndYear);
                                break;

                                // Run main process on this input
                                Class1 mp = new Class1(LocalDataBase, Country, State, County, City,
                                                MaximumLAI, EvergreenPercent, LAIDatabase, StartYear, EndYear, vegType,
                                                  SurfaceWeatherDataFile, RainDataExcel, WeatherDatabase);
                                mp.Run();
                                //               
                                //              
                        }
                        //
                        Console.WriteLine("");
                    }
                }
            }

            Console.ReadKey();

        }
    }
}
