﻿//WARNING: Do not update RestSharp beyond 106.x due to dependency on SqlWeb.Data and RestClient.ClearHandlers().

//System for Console, Environment
using System;
//System.Xml for reading the config (in ReadWeatherPrepConfig.cs)
using System.Xml;
//System.IO for Path.Combine
using System.IO;
//NHibernate for ISession, SessionHelper.OpenSession()
//Note: NHibernate located at: https://data.itreetools.org/sql
using NHibernate;
//LocationSpecies.Domain for Location, passed into CreateOutputFiles()
//Note: LocationSpecies.Domain used and is combination of Location and Species Database
using LocationSpecies.Domain;

namespace WeatherPrep
{

    class SimulationManager
    {
        static void Main(string[] args)
        {
            if (args.Length == 0)
            {
                Console.WriteLine("Please enter a path to the input data XML file at the command line, as illustrated below:");
                Console.WriteLine("\nWeatherPrep.exe  C:\\iTree\\WeatherPrep\\input_output");
                System.Environment.Exit(1);
            }

            string dirPath = args[0];

            Console.WriteLine("Reading WeatherPrepConfig.xml from: " + dirPath + "\n");

            // Load config values from the XML file using your new ReadWeatherPrepConfig class
            ConfigData config = ReadWeatherPrepConfig.Load(dirPath);

            //using (ISession NHibernate_Session = SessionHelper.OpenSession() connects via NHibernate to LocationSpecies Database
            //Note: SessionHelper.cs is 
            using (ISession NHibernate_Session = SessionHelper.OpenSession())
            {
                //Location location = LocationData.LookupLocation obtains Place, County, State, Nation
                //Note: NHibernate uses LINQ to send a request to the database (via REST through SqlWebConnection) and ...
                //Note: ... receive a JSON response and map it into a Location object
                //Note: The location object contains values like: Latitude, Longitude, GrowthPeriod.LeafOnDays, TimeZone.Offset
                Location location = LocationData.LookupLocation(
                    NHibernate_Session,
                    config.Place,
                    config.County,
                    config.State,
                    config.Nation
                );

                //CreateOutput output = new CreateOutput obtains variables MaximumLAI etc. 
                CreateOutput output = new CreateOutput(
                    config.MaximumLAI,
                    config.EvergreenPercent,
                    config.LAIDatabasePath,
                    config.StartYear,
                    config.EndYear,
                    config.VegType,
                    config.WeatherDataPath,
                    config.PrecipDataPath,
                    config.WeatherDatabasePath,
                    config.Model,
                    config.WindSensorHeight,
                    config.TreeHeight
                );

                //output.CreateOutputFiles(NHibernate_Session, location) writes output
                output.CreateOutputFiles(NHibernate_Session, location);
            }

            Console.WriteLine("\nProgram completed successfully.");
        }
    }
}
