#z_PrecipitationData_GIOVANNI.py will process NASA GIOVANNI server GPM_3IMERGHH data into format usable by i-Tree
#Note: Script can be run in two approaches, explained below as P and W:

#Created by Jay Heppler at Davey Institute for processing of international weather data lacking precipitation
#Updated by T. Endreny at SUNY ESF with various user and runtime features 

#Test:>python z_b_PrecipitationData_GIOVANNI.py C:\iTree\WeatherPrep\TestingFilesAndScript\TestCases\z_GiovannieSample

#Approach P: Generate precipitation csv, to use in in WeatherPrepConfig.xml and create Weather.csv 
#Step 1a: Download WeatherPrep scripts and utility from i-Tree Tools and save as: C:\iTree\WeatherPrep\
#Step 1b: Follow directions in C:\iTree\WeatherPrep\NOAA_data_tool\ReadMe.txt to obtain raw NOAA data 
#Step 1c: Create work folder such as C:\iTree\a_prep_Weather\syr_ny\2022\ to contain the raw NOAA data
#Step 2a: Obtain data at https://giovanni.gsfc.nasa.gov/giovanni/ by: 
#Step 2b: ... 1) Select Plot Time Series, Area Averaged, 2) Select Date Range (UTC) starting 1998-01-01, ...
#Step 2c: ... 3) Select Region (W,S,E,N) based on 0.05 degree distances from city center, 4) Keyword GPM_3IMERGHH, ... 
#Step 2d: ... 5) Select best data option (e.g., Precipitation, Units=mm/hr, Temp.Res=Half-Hourly), ...
#Step 2e: ... 6) Click Plot Data & wait ...
#Step 2f: ... 7) Once plot is generated, expand Downloads left of plot and select CSV, 8, Save to work folder
#Step 2g: Keep original name of GPM_3IMERGHH product, e.g., g4.areaAvgTimeSeries.GPM_3IMERGHH.._precip..12E_42N.csv
#Step 3a: Run this GIOVANNI script and select data output option letter P, for Precipitation.csv
#Step 4a: Either/Or Run WeatherPrep_GUI.exe or WeatherPrep_GUI.py, activating Advanced XML Configuration radio button
#Step 4b: Provide path for GIOVANNI output Precipitation.csv
# 
#Step 5a: Either/Or Modify WeatherPrepConfig.xml element PrecipitationDataCsv to point to Precipitation.csv
#Step 5b: Generate weather.csv file that contains the GIOVANNI precipitation data

#Approach W: Update weather.csv, by combining precipitation csv with existing Weather.csv
#Step 1a: Download WeatherPrep scripts and utility from i-Tree Tools and save as: C:\iTree\WeatherPrep\
#Step 1b: Follow directions in C:\iTree\WeatherPrep\NOAA_data_tool\ReadMe.txt to obtain raw NOAA data 
#Step 1c: Create work folder such as C:\iTree\a_prep_Weather\syr_ny\2022\ to contain the raw NOAA data
#Step 2a: Follow directions in C:\iTree\WeatherPrep\TestCases\ReadMe.txt
#Step 2b: Modify WeatherPrepConfig.xml element PrecipitationDataCsv to be blank
#Step 2c: Generate 1st estimate of weather.csv file that does not yet contain the GIOVANNI precipitation data
#Step 3a: Obtain data at https://giovanni.gsfc.nasa.gov/giovanni/ by: 
#Step 3b: ... 1) Select Plot Time Series, Area Averaged, 2) Select Date Range (UTC), ...
#Step 3c: ... 3) Select Region (E,S,W,N), 4) Keyword GPM_3IMERGHH, ... 
#Step 3d: ... 5) Select best data option (e.g., Precipitation, Units=mm/hr, Temp.Res=Half-Hourly), ...
#Step 3e: ... 6) Click Plot Data & wait ...
#Step 3f: ... 7) Once plot is generated, expand Downloads left of plot and select CSV, 8, Save to work folder
#Step 3g: Keep original name of GPM_3IMERGHH product, e.g., g4.areaAvgTimeSeries.GPM_3IMERGHH.._precip..12E_42N.csv
#Step 4a: Run this GIOVANNI script and select data output option letter W, for Weather.csv
#Step 4b: Update weather.csv file to contain the GIOVANNI precipitation data

#Giovanni input data as CSV file is formatted as:
#Date_YYYYMMDD Time_HH:MM:SS,Precipitation_mm
#2019-01-01 00:00:00,0.76200000
#2019-01-01 01:00:00,0.00000000

import csv
import os 
import datetime 
import glob 
import shutil
import pandas as pd
import sys


#If len sys.argv < 2 then command line argument missing
if len(sys.argv) < 2:
    print("Warning: Python script requires command line input of a <target_directory>")
    print("This script searches the target_directory for a precipitation data file:")
    print("- with a name containing the keyword 'GPM_3IMERGHH',")
    print("- in the format of a NASA GIOVANNI IMERGE .csv file.")
    sys.exit(1)
#target_directory is the path given in sys.argv[1]
target_directory = sys.argv[1]
    
#Before running script, put weather file of interest and GIOVANNI file of interest into same folder. 
os.chdir(target_directory)


#precip_find uses glob.glob command to find file with string *GPM_3IMERGHH*, as named by Giovanni output
precip_find = glob.glob('*GPM_3IMERGHH*')

#if precip_find returns no results
if len(list(precip_find)) == 0:
    print("Warning: No precipitation data were found in the target_directory: \n{}.".format(target_directory))
    print("This script searches the target_directory for a precipitation data file:")
    print("- with a name containing the keyword 'GPM_3IMERGHH',")
    print("- in the format of a NASA GIOVANNI IMERGE .csv file.")
else:
    pass 
    
#Prompt for command line input whether program generates Precipitation.csv or Weather.csv
print("Please select one of two options for inserting the precipitation data, P or W.")
print("P = Precipitation.csv generated to create Weather.csv file using WeatherPrepConfig.xml.")
print("W = Weather.csv updated to contain the precipitation data.")
output_choice = input('Select a letter: Precipitation.csv generated or Weather.csv updated (P or W):')
#Substring output_choice to ensure accurate input
output_choice = output_choice[0:]

#Initiate flags
flag_Precipitation = 0
flag_Weather = 0

#Define 1st row of Giovanni IMERGE precipitation data
row_start_precipitation_input = 9

#If output_choice is P or p then only generate Precipitation.csv file
if (output_choice == 'P' or output_choice == 'p'):
    #Set flag_Precipitation to 1
    flag_Precipitation = 1
    #set flag_Weather to 0
    flag_Weather = 0
else:
    #set flag_Weather to 1
    flag_Weather = 1
    #Set flag_Precipitation to 0
    flag_Precipitation = 0

#precip_file defined by Python function os.path.join with 1st part of precip_find string variable
precip_file = os.path.join(os.getcwd(), str(precip_find[0]))

#Create Precipitation.csv as time series of Giovanni IMERGE precipitation 
precip_file_copy = os.path.join(os.getcwd(), 'Giovanni_IMERGE_Data.csv')
#Create working copies using shutil function
shutil.copy(precip_file, precip_file_copy)

if flag_Weather == 1:
    #find Weather file, create variable containing full path name. 
    weather_find = glob.glob('Weather.csv')  
    weather_file = os.path.join(os.getcwd(), str(weather_find[0]))
    #Create working copy directories
    print("Weather.wc.csv and Weather.2.csv will appear in your directory as temporary files during merge.")
    weather_file_copy = os.path.join(os.getcwd(), 'Weather.wc.csv')
    #Create working copies
    shutil.copy(weather_file, weather_file_copy)

#with open Python command uses precip_file_copy, named f0
with open(precip_file_copy) as f0:
    #lines_precip holds all f0 lines using Python csv.reader function
    lines_precip = csv.reader(f0)
    #raw_data_precip holds all lines_precip as rows
    raw_data_precip = [row for row in lines_precip]
    
    #row_count_p variable defines length of input file, raw_data_precip, to define length of loop
    row_count_p = len(list(raw_data_precip))
    
    #first_datetime defined using Python function datetime.datetime.strptime 
    #Note: "%Y-%m-%d %H:%M:%S" defines format of Giovanni IMERGE input date and time
    first_datetime = datetime.datetime.strptime(raw_data_precip[row_start_precipitation_input][0], "%Y-%m-%d %H:%M:%S")
        
    #If first_datetime.minute greater than 1 then it is row at a 30 minute time interval, so advance 1 row
    if first_datetime.minute >= 1:
        first_datetime = datetime.datetime.strptime(raw_data_precip[row_start_precipitation_input + 1][0], "%Y-%m-%d %H:%M:%S")
        start_range = row_start_precipitation_input + 1
    else:
        start_range = row_start_precipitation_input
        
    #Confirm start range
    print('Preparing to merge precipitation data starting at row {} and date {}'.format(start_range, first_datetime))
    print("If a different date is needed, then stop and edit script variable row_start_precipitation_input.")

    #create empty list for CSV
    Giovanni_precipitation_data_mph = []
    output_data_date = []
    output_data_time = []
    
import pandas as pd
import os
from datetime import datetime

# Initialize lists to collect data
output_data_date = []
output_data_time = []
Giovanni_precipitation_data_mph = []

ratio_m_to_mm = 1.0/1000.0
ratio_30min_to_60min = 30.0/60.0

#Read in Giovanni precipitation data and write to dataframe then to CSV file
#Note: Giovanni GPM_3IMERGHH precipitation has units of mm/hr for each 30 min time step
#For loop of j in range start_range to row_count_p, stepping by 2 rows
for j in range(start_range, row_count_p, 2):
    #precip_mm (mm) is weighted average of two rows of 30 min precipitation depths, in 2nd column of input data
    #Note: precip_mm = (raw_data_precip[j][1] + raw_data_precip[j+1][1]) * ratio_30min_to_60min
    #Note: Equation converts mm/hr to mm for 30 min duration, and then adds the two 30 min depths for mm in 60 min
    precip_mm = (float(raw_data_precip[j][1]) + float(raw_data_precip[j+1][1])) * ratio_30min_to_60min
    #precip_m (m) product of precip_mm (mm) and ratio_m_to_mm
    precip_m = precip_mm * ratio_m_to_mm
    
    #precip_date_time_temp_str is string of date-time in 1st column of input ratio_m_to_mm
    precip_date_time_temp_str = str(raw_data_precip[j][0])
    #precip_date_time_temp_dt is using datetime.strptime with precip_date_time_temp_str, noting '-' separators
    precip_date_time_temp_dt = datetime.strptime(precip_date_time_temp_str, "%Y-%m-%d %H:%M:%S")
    #YYYYMMDD_str is string of precip_date_time_temp_dt, using strftime function in format of YYYYMMDD
    YYYYMMDD_str = precip_date_time_temp_dt.strftime("%Y%m%d")
    #HHMMSS_str is string of precip_date_time_temp_dt, using strftime function in format of HH:MM:SS
    HHMMSS_str = precip_date_time_temp_dt.strftime("%H:%M:%S")
    
    #output_data_date list is appended with YYYYMMDD_str
    output_data_date.append(YYYYMMDD_str)
    #output_data_time list is appended with HHMMSS_str
    output_data_time.append(HHMMSS_str)
    #Giovanni_precipitation_data_mph list is appended with precip_m
    Giovanni_precipitation_data_mph.append(precip_m)

#df_p panda dataframe is created to contain the three lists of Date, Time, Precipitation
df_p = pd.DataFrame({
    'YYYYMMDD': output_data_date,
    'HH:MM:SS': output_data_time,
    'Precipitation_Rate_mph(m/h)': Giovanni_precipitation_data_mph})

#output_file_precip combines the directory path and Precipitation.csv, using os.path.join function
output_file_precip = os.path.join(os.getcwd(), 'Precipitation.csv')
#df_p is converted to a csv file, using function .to_csv with output_file_precip
df_p.to_csv(output_file_precip, index=False)

print("Processed all Giovanni precipitation data")

#If flag_Weather is true then write precipitation to Weather.csv
if flag_Weather == 1:
    #output_data_weather is empty list
    output_data_weather = []
    #open weather file 
    with open(weather_file_copy) as f1:
        lines_weather = csv.reader(f1)
        Weather_HydroPlus_data = [row for row in lines_weather]
        #get row count to determine length of loop
        row_count_weather = len(list(Weather_HydroPlus_data))
        row_count_precip = len(Giovanni_precipitation_data_mph)
        print("Number of rows of precipitation data = {}.".format(row_count_precip))
        
        #Warning in case row_count_weather and row_count_precip do not match. If the weather is an annual generation, this may be because the weather data for December 31 is missing. 
        if row_count_weather == row_count_precip:
            print("Excellent: Date range matches for weather.csv and precipitation file.")
            print("Writing final weather file now.")
        if row_count_weather > row_count_precip: 
            print("Concern: Weather observations appear to outnumber precipitation observations.")
        if row_count_weather < row_count_precip:
            print("Concern: Precipitation observations appear to outnumber weather observations.")

        #Weather_header is header row from Weather_HydroPlus_data, row 0
        Weather_header = Weather_HydroPlus_data[0]
        #Weather_header_len is the length of Weather_header
        Weather_header_len = len(Weather_header)

        #output_data_weather appends Weather_header as 1st item
        output_data_weather.append(Weather_header)
                    
        #For loop with j from 1 to row_count_weather at step 1
        for j in range(1, row_count_weather, 1):
                    
            #If Weather_header_len=9 then Weather.csv is for i-Tree Energy with 10 items in header 
            if (Weather_header_len == 9):
                #YYYYMMDD and all but 1 variable are from Weather_HydroPlus_data at j, column 0 to 8
                #Note: Precip_mph is from Giovanni_precipitation_data_mph, not from Weather_HydroPlus_data
                YYYYMMDD = Weather_HydroPlus_data[j][0]
                HHMMSS = Weather_HydroPlus_data[j][1]
                Tair_F = Weather_HydroPlus_data[j][2]
                Tdew_F = Weather_HydroPlus_data[j][3]
                NetRad_Wpm2 = Weather_HydroPlus_data[j][4]
                WndSpd_mps = Weather_HydroPlus_data[j][5]
                AtmPres_kPa = Weather_HydroPlus_data[j][6]
                #Precip_mph is from Giovanni_precipitation_data_mph, Giovanni data at [j-1]
                Precip_mph = f"{float(Giovanni_precipitation_data_mph[j-1]):.8f}"
                SnowDepth_m = Weather_HydroPlus_data[j][8]
                #row_data_weather combines the variables into one list 
                row_data_weather = [YYYYMMDD, HHMMSS, Tair_F, Tdew_F, NetRad_Wpm2, WndSpd_mps, AtmPres_kPa, Precip_mph, SnowDepth_m]
            #If Weather_header_len=10 then Weather.csv is for i-Tree Energy with 11 items in header 
            #Note: i-Tree Energy includes WindDir_deg as additional variable
            if (Weather_header_len == 10):
                #YYYYMMDD and all but 1 variable are from Weather_HydroPlus_data at j, column 0 to 9
                YYYYMMDD = Weather_HydroPlus_data[j][0]
                HHMMSS = Weather_HydroPlus_data[j][1]
                Tair_F = Weather_HydroPlus_data[j][2]
                Tdew_F = Weather_HydroPlus_data[j][3]
                NetRad_Wpm2 = Weather_HydroPlus_data[j][4]
                WndSpd_mps = Weather_HydroPlus_data[j][5]
                WindDir_deg = Weather_HydroPlus_data[j][6]
                AtmPres_kPa = Weather_HydroPlus_data[j][7]
                #Precip_mph is from Giovanni_precipitation_data_mph, Giovanni data at [j-1]
                Precip_mph = f"{float(Giovanni_precipitation_data_mph[j-1]):.8f}"
                SnowDepth_m = Weather_HydroPlus_data[j][9]
                #row_data_weather combines the variables into one list 
                row_data_weather = [YYYYMMDD, HHMMSS, Tair_F, Tdew_F, NetRad_Wpm2, WndSpd_mps, WindDir_deg, AtmPres_kPa, Precip_mph, SnowDepth_m]
                
            #output_data_weather is appended with row_data_weather
            output_data_weather.append(row_data_weather) 
            
    #df_w panda dataframe created to contain output_data_weather
    df_w = pd.DataFrame(output_data_weather)
    #output_file_weather combines the directory path and Weather2.csv, using os.path.join function
    output_file_weather = os.path.join(os.getcwd(), 'Weather2.csv')
    #df_w is converted to a csv file, using function .to_csv with output_file_weather
    df_w.to_csv(output_file_weather, header= False, index= False)
    
    print("Processed all Weather.csv and Giovanni data")

#If flag_Weather is true then remove and copy certain files
if flag_Weather == 1:        
    os.remove(weather_file_copy)
    #copies new CSV (Weather2) to the same name as the old weather_file
    shutil.copy(output_file_weather, weather_file)
    os.remove(output_file_weather)
    os.remove(output_file_precip)
    print("Weather.csv was updated and is ready within the folder with the raw precipitation data.")
    print("File path: {}".format(weather_file))
else:
    print("Precipitation.csv was generated and is ready within the folder with the raw precipitation data.")
    print("File path: {}".format(output_file_precip))

print("Script has completed. Check above output files for results.")
print("Thank you for using i-Tree tools to improve the world!")

#delete all intermediate files 
os.remove(precip_file_copy)
