#ifndef AggregateOutput_H
#define AggregateOutput_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include "../Inputs/Inputs.h"
#include "../DataOrganizer.h"
#include "../DataFolder.h"

//Conversion between kg and g
#define Ratio_kg_to_g 1.0/1000.0
//Conversion mm to m
#define Ratio_mm_to_m 1000.0

//MAX function for finding minimum of x_var and y_var using conditional ternary operator (?:)
//Note: Ternary operator explained: For (x_var<=y_var?x_var:y_var), if x_var<=y_var is true, then x_var is taken, otherwise y_var taken.
#define MAX(x_var,y_var) (((x_var)>=(y_var)) ? (x_var) : (y_var))        

class AggregateOutput
{
public:

	static void SumCatchmentTotals(Inputs* input, CompactRagged* beC, int DataDrawer_ID, int DataFolder_ID, int timeStep);
	static void SumTimeStepTotals(Inputs* input, int timeStep);
	static void TS_First_Last(Inputs* input, CompactRagged* beC, int DataDrawer_ID, int DataFolder_ID, int timeStep, int Folder_Type_ID, double Folder_Area_m2, double PC_m2, double IC_m2, double TC_m2, double SVegC_noTC_m2, double SoilC_noTC_m2, double PermeablePavementC_noTC_m2, double WaterC_noTC_m2, double IC_noTC_m2, double NoCanopy_m2, double Ratio_FolderTypeArea_to_CatchmentTypeArea, double Catchment_Pervious_Area_m2);
	static void Initialize(Inputs* input, int timeStep);
};

#endif