#ifndef SolarCalculation_H
#define SolarCalculation_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include <iostream>
#include <fstream>
#include <vector>
//_USE_MATH_DEFINES gives access to Pi as M_PI, and must precede #include <cmath> or <math.h>
#define _USE_MATH_DEFINES
#include <cmath>
#include <math.h>
#include <stdio.h>
#include <vector>
#include "../Inputs/Inputs.h"

#define MINPDEG        4.		    /* minutes per degree longitude */
#define DEGPRAD        57.29578	    /* degree per radian */
#define MINPHOUR       60
#define DAYPYEAR       365
#define RADPHOUR       0.2617994   /* radians per hour: Earth's Rotation 
								   (2 PI rad/day) * (1 day/24 h) */
#define RADPDEG       (M_PI/180.0)	   /* radians per degree */
#define SOLARCON      1360.	        /* Solar constant (W/m^2) */

///////////////////////////////////////////////////////////////
//      SolarCalulation class declarations					 //   
//      Using the "CalcSolar.c" file in DHSVM model          //
///////////////////////////////////////////////////////////////

class SolarCalculation
{
public:

	SolarCalculation(Inputs* input);

	SolarCalculation() {};
	~SolarCalculation() {};

	void SolarDay();
	void SolarHour(Inputs* input, int timeStep);
	//void SolarConst(float, float, float, float);
	void SolarConst();
	int DayOfYear();
	char IsLeapYear(int);

	double getSolarAzimuth() { return SolarAzimuth; }
	double getSolarAltitude() { return SolarAltitude; }
	double getSolarZenith() { return SolarZenithHFlux; }

	double getSolAzimuth(int i) { return SolAzimuth[i]; }
	double getSolAltitude(int i) { return SolAltitude[i]; }
	vector<double> getSolZenith() { return SolZenith; }

private:
	Inputs* input;
	
	int startYear;
	int startMonth;
	int startDay;
	double latDeg;
	double latMin;
	double lngDeg;
	double lngMin;
	float stdMeridian;

	double SolarAzimuth = 0;
	double SolarAltitude = 0;		// SolarAltitude of sun from horizon (rads)
	int Day_JulianDay;
	float Latitude_rad;
	float Longitude;
	float NoonHour = 12.0;   //work in solar time
	float Sunrise;
	float Sunset;
	float Declination;
	float TimeAdjustment;
	float SunEarthDist;
	float SineSolarAltitude = 0.0;
	int Daylight;
	float SunMax = 0.0;
	float SolarTimeStep = 1.0;
	//sun zenith angle (rads)
	double SolarZenith;		
	double SolarZenithHFlux;

	vector<double> SolAzimuth, SolAltitude, SolZenith;
};

#endif