#include "Leave_GI_Device.h"

//Leave_GI_Device::CollectVariables function organizes the storage and flux variables for the GI devices
void Leave_GI_Device::CollectVariables(Inputs* input, CompactRagged* beC, int DataDrawer_ID, int DataFolder_ID, int timeStep)
{
	//Total_Drainage_GI_Pavement_m3 (m3) is increased by Percolation_Pavement_m3 (m3)
	beC->by_key(DataDrawer_ID, DataFolder_ID, "Total_Drainage_GI_Pavement_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Total_Drainage_GI_Pavement_m3") + beC->by_key(DataDrawer_ID, DataFolder_ID, "Percolation_Pavement_m3");
	//Total_GI_Drainage_VadoseZone_m3 (m3) increased each timeStep by with Drainage_VadoseZone_m3 (m3) 
	beC->by_key(DataDrawer_ID, DataFolder_ID, "Total_GI_Drainage_VadoseZone_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Total_GI_Drainage_VadoseZone_m3") + beC->by_key(DataDrawer_ID, DataFolder_ID, "Drainage_VadoseZone_m3");

	//Infiltration_m (m) as pervious area depth derived from Infiltration_Surface_m3 (m3), updated in GI_Flux_Storage_Balancer function, dividing with ...
	//Note: ... Area_GI_Unit_Pervious_m2 (m2) and multiplying by (1 - Soil_Macropore_frac) to get fraction not going to macropores
	beC->by_key(DataDrawer_ID, DataFolder_ID, "Infiltration_m") = (beC->by_key(DataDrawer_ID, DataFolder_ID, "Infiltration_Surface_m3") / beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_GI_Unit_Pervious_m2")) * (1 - beC->by_key(DataDrawer_ID, DataFolder_ID, "Soil_Macropore_frac"));
	//Drainage_macroPore_m (m) as pervious area depth derived from Infiltration_Surface_m3 (m3), updated in GI_Flux_Storage_Balancer function, dividing with ...
	//Note: ... Area_GI_Unit_Pervious_m2 (m2) and multiplying by Soil_Macropore_frac to get fraction going to macropores
	//Note: Infiltration_Surface_m3 (m3) includes Drainage_macroPore_m for GI device vertical balance
	beC->by_key(DataDrawer_ID, DataFolder_ID, "Drainage_macroPore_m") = (beC->by_key(DataDrawer_ID, DataFolder_ID, "Infiltration_Surface_m3") / beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_GI_Unit_Pervious_m2")) * beC->by_key(DataDrawer_ID, DataFolder_ID, "Soil_Macropore_frac");
	//Infiltration_viaSatEx_m (m) recomputed w Infiltration_m (m) and InfiltExcessGovernedArea_frac 
	beC->by_key(DataDrawer_ID, DataFolder_ID, "Infiltration_viaSatEx_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Infiltration_m") * (1 - beC->by_key(DataDrawer_ID, DataFolder_ID, "InfiltExcessGovernedArea_frac"));
	beC->by_key(DataDrawer_ID, DataFolder_ID, "Infiltration_viaInfilEx_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Infiltration_m") * beC->by_key(DataDrawer_ID, DataFolder_ID, "InfiltExcessGovernedArea_frac");

	//Equations to scale from volume for one GI unit to volume for all GI units by Count_GI_Units
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Precipitation_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Flux_to_GI_Precipitation_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Inflow_from_BulkArea_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Flux_BulkArea_to_GI_Runon_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Infiltration_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Infiltration_Surface_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Drainage_PercolationPavement_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Percolation_Pavement_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Drainage_Percolation_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Percolation_Soil_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Drainage_Exfiltration_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Exfiltration_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Drainage_VadoseZone_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Drainage_VadoseZone_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	//Note: Consider refactor to send to beC->by_key Runoff_GI_Outlet_m3 and Runoff_GI_Berm_m3 as two components of GI_Runoff_Surface_m
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Runoff_Surface_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Runoff_Surface_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Runoff_Vault_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Runoff_Vault_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_EvaporationSurface_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "EvapoTrans_Surface_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_EvaporationPavement_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "EvapoTrans_Pavement_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_EvaporationSoil_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "EvapoTrans_Soil_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_EvaporationVault_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "EvapoTrans_Vault_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_EvaporationAllLayers_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "EvapoTranspiration_GI_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Storage_SurfaceLayer_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Storage_GI_Surface_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Storage_PavementLayer_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Storage_GI_Pavement_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Storage_SoilLayer_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Storage_GI_Soil_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Storage_VaultLayer_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Storage_GI_Vault_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Storage_GroundwaterMound_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Storage_GroundwaterMound_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Storage_GI_Pavement_Max_Potential_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Storage_GI_Pavement_Max_Potential_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Storage_GI_Pavement_Max_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Storage_GI_Pavement_Max_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Storage_GI_Soil_Max_Potential_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Storage_GI_Soil_Max_Potential_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Storage_GI_Soil_Max_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Storage_GI_Soil_Max_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Storage_GI_Vault_Max_Potential_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Storage_GI_Vault_Max_Potential_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Storage_GI_Vault_Max_m3") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Storage_GI_Vault_Max_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");

	double Folder_Pervious_Area_m2 = beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_m2") * beC->by_key(DataDrawer_ID, DataFolder_ID, "PerviousCover_frac");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "Drainage_VadoseZone_m") = 0;
	beC->by_key(DataDrawer_ID, DataFolder_ID, "Drainage_SoilEvapZone_m") = 0;
	//If Folder_Pervious_Area_m2 > 0 then enter and divide by Folder_Pervious_Area_m2
	if (Folder_Pervious_Area_m2 > 0) {
		//Drainage_VadoseZone_m (m) generated as pervious cover depth by dividing GI_Drainage_VadoseZone_m3 (m3) by Folder_Pervious_Area_m2 (m2)
		beC->by_key(DataDrawer_ID, DataFolder_ID, "Drainage_VadoseZone_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Drainage_VadoseZone_m3") / Folder_Pervious_Area_m2;
		//Drainage_SoilEvapZone_m (m) generated as pervious cover depth by dividing GI_Drainage_VadoseZone_m3 (m3) by Folder_Pervious_Area_m2 (m2)
		//Note: Drainage_SoilEvapZone_m (m) is maximum of GI_Drainage_Percolation_m3 (m3) and GI_Drainage_PercolationPavement_m3 (m3) divided by Folder_Pervious_Area_m2
		beC->by_key(DataDrawer_ID, DataFolder_ID, "Drainage_SoilEvapZone_m") = MAX(beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Drainage_Percolation_m3"), beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Drainage_PercolationPavement_m3")) / Folder_Pervious_Area_m2;
	}
	//If Drainage_SoilEvapZone_m (m) is zero, then GI has no soil or pervious layer, and inflow is directly to the vault layer
	if (beC->by_key(DataDrawer_ID, DataFolder_ID, "Drainage_SoilEvapZone_m") <= 0) {
		//Drainage_SoilEvapZone_m (m) is equal to Drainage_VadoseZone_m (m) when vault is exposed to surface layer
		beC->by_key(DataDrawer_ID, DataFolder_ID, "Drainage_SoilEvapZone_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Drainage_VadoseZone_m");
	}

	//Runoff_Pervious_m3 (m3) is pervious fraction of Runoff_Surface_m3, scaled from one GI unit to all GI units by Count_GI_Units, transferred to RunoffSummation
	input->RepoDict["Runoff_Pervious_m3"] = beC->by_key(DataDrawer_ID, DataFolder_ID, "Runoff_Pervious_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	//Runoff_Impervious_m3 (m3) is impervious fraction of Runoff_Surface_m3, scaled from one GI unit to all GI units by Count_GI_Units, transferred to RunoffSummation
	input->RepoDict["Runoff_Impervious_m3"] = beC->by_key(DataDrawer_ID, DataFolder_ID, "Runoff_Impervious_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	//Runoff_Water_m3 (m3) is water cover fraction of Runoff_Surface_m3, scaled from one GI unit to all GI units by Count_GI_Units, transferred to RunoffSummation
	input->RepoDict["Runoff_Water_m3"] = beC->by_key(DataDrawer_ID, DataFolder_ID, "Runoff_Water_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");
	//Runoff_Vault_m3 (m3) is Runoff_Vault_m3 from pervious or impervius vault layer, scaled from one GI unit to all GI units by Count_GI_Units, transferred to RunoffSummation
	input->RepoDict["Runoff_Vault_m3"] = beC->by_key(DataDrawer_ID, DataFolder_ID, "Runoff_Vault_m3") * beC->by_key(DataDrawer_ID, DataFolder_ID, "Count_GI_Units");

	//GI Variables as depths (m) constructed
	//GI water volumes (m3) scaled to folder area depths (m) by division with Area_per_GIUnit_m2; equivalent to GI device depth given volume is for device
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Precipitation_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Flux_to_GI_Precipitation_m3") / beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_GI_Unit_m2");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Inflow_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Flux_BulkArea_to_GI_Runon_m3") / beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_GI_Unit_m2");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Infiltration_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Infiltration_Surface_m3") / beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_GI_Unit_m2");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Drainage_PercolationPavement_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Percolation_Pavement_m3") / beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_GI_Unit_m2");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Drainage_Percolation_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Percolation_Soil_m3") / beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_GI_Unit_m2");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Drainage_Exfiltration_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Exfiltration_m3") / beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_GI_Unit_m2");

	//Note: Consider refactor to use Runoff_Pervious_m3 to define Runoff_SatExcess_m and Runoff_InfilExcess_m
	//Note: Consider refactor to send to beC->by_key Runoff_GI_Outlet_m3 and Runoff_GI_Berm_m3 as two components of GI_Runoff_Surface_m
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Runoff_Surface_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Runoff_Surface_m3") / beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_GI_Unit_m2");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Runoff_Vault_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Runoff_Vault_m3") / beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_GI_Unit_m2");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_EvaporationSurface_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "EvapoTrans_Surface_m3") / beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_GI_Unit_m2");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_EvaporationPavement_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "EvapoTrans_Pavement_m3") / beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_GI_Unit_m2");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_EvaporationSoil_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "EvapoTrans_Soil_m3") / beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_GI_Unit_m2");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_EvaporationVault_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "EvapoTrans_Vault_m3") / beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_GI_Unit_m2");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_EvaporationAllLayers_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "EvapoTranspiration_GI_m3") / beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_GI_Unit_m2");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Storage_PavementLayer_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Storage_GI_Pavement_m3") / beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_GI_Unit_m2");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Storage_SurfaceLayer_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Storage_GI_Surface_m3") / beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_GI_Unit_m2");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Storage_SoilLayer_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Storage_GI_Soil_m3") / beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_GI_Unit_m2");
	beC->by_key(DataDrawer_ID, DataFolder_ID, "GI_Storage_VaultLayer_m") = beC->by_key(DataDrawer_ID, DataFolder_ID, "Storage_GI_Vault_m3") / beC->by_key(DataDrawer_ID, DataFolder_ID, "Area_GI_Unit_m2");
}