#ifndef MAPRESAMPLER_H
#define MAPRESAMPLER_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include <vector>
#include <cmath> 
#include <algorithm>
#include <iostream>
#include <numeric>
#include <fstream> 
#include <iomanip>

//using namespace std allows for use of standard namespace without the preface 
using namespace std;

//Forward declaration of class Inputs
class Inputs;

class MapResampler {
public:
    static void ResampleAnthropogenicHeatFlux_Map(Inputs* input, vector<double>& AnthropogenicHeat_Flux_Qtot_Avg_Wpm2, vector<double>& AnthropogenicHeat_Flux_Qcr_Avg_Wpm2, vector<double>& AnthropogenicHeat_Flux_Qncr_Avg_Wpm2, const vector<double>& ImperviousCover_frac, int nCols, int nRows, double lowerLeftX_m, double lowerLeftY_m, double cellSize_m, double NODATA_code, int Flag_AH_Flux_Qcr_Qncr_not_Qtot, int Flag_AH_Flux_Maps_Resample, int Map_OriginalScaleGrid_m, double AnthropogenicHeat_Flux_Qtot_Map_Sum_Wpm2, double AnthropogenicHeat_Flux_Qcr_Map_Sum_Wpm2, double AnthropogenicHeat_Flux_Qncr_Map_Sum_Wpm2, double ImperviousCover_Sum_frac, string OutputFolder_Path, double RefWeatherLocationAH_Flux_Qtot_Avg_Wpm2);


private:
    static double ComputeMeanMapPixelValue(const vector<double>& data, int centerRow, int centerCol, int radius, int nCols, int nRows, double NODATA_code);
    static double ComputeMedianMapPixelValue(const vector<double>& data, int centerRow, int centerCol, int radius, int nCols, int nRows, double NODATA_code);
    static void WriteRasterToFile(const string& filename,const vector<double>& data,int nCols, int nRows, double lowerLeftX_m, double lowerLeftY_mdouble, double cellSize_m, double NODATA_code);
    static void WriteResampledMaps(Inputs* input, const vector<double>& AnthropogenicHeat_Flux_Qtot_Avg_Wpm2, const vector<double>& AnthropogenicHeat_Flux_Qcr_Avg_Wpm2, const vector<double>& AnthropogenicHeat_Flux_Qncr_Avg_Wpm2, const string& outputFolderPath, int nCols, int nRows, double lowerLeftX_m, double lowerLeftY_mdouble, double cellSize_m, double NODATA_Code, int Flag_AH_Flux_Qcr_Qncr_not_Qtot);

    string OutputFolder_Path, Flag_AH_Flux_Qcr_Qncr_not_Qtot;
    double NODATA_code, cellsize_m;
    int nCols, nRows;
};

#endif
