#ifndef SolarCalculator_H
#define SolarCalculator_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/

//_USE_MATH_DEFINES gives access to Pi as M_PI, and must precede #include <cmath> or <math.h>
#define _USE_MATH_DEFINES
#include <cmath>
#include <math.h>
#include <string>
#include <utility>
#include <map>
#include <vector>
#include <sstream>
#include "Inputs.h"
#include "../DataFolder.h"


#define AtmosphericPressure_SeaLevel_hPa 1013.25
#define AtmosphericTemperature_Avg_K 288.15


class SolarCalculator
{

public:
	SolarCalculator(Inputs* input);
	//~SolarCalculator() {} destructor that ensures resources used by the object can be released 
	~SolarCalculator() {};

	//SolarCalculator_Inputs function will manage call to calculate the wet bulb globe temperature
	void SolarCalculator_Inputs(Inputs* input, CompactRagged* beC, WeatherProcessor* WeatherPro, string StationID_string, int MapPixel_ID, int DataFolder_ID, int timeStep, int Flag_simulateReferenceStation);

	//Ratio_AlbedoDirectCZA_to_AlbedoDirectCZA60 function implements Eq 15 of Yang et al. (2008)
	double Ratio_AlbedoDirectCZA_to_AlbedoDirectCZA60(double Cos_ZenithAngle_Solar);

	double get_Cos_ZenithAngle_Solar() { return Cos_ZenithAngle_Solar; }
	double get_Cos_IncidenceAngle_Solar() { return Cos_IncidenceAngle_Solar; }
	double get_ZenithAngle_Solar_rad() { return ZenithAngle_Solar_rad; }
	double get_AzimuthAngle_Solar_N_0_rad() { return AzimuthAngle_Solar_N_0_rad; }
	double get_DeclinationAngle_Solar_rad() { return DeclinationAngle_Solar_rad; }
	double get_HourAngle_Solar_rad() { return HourAngle_Solar_rad; }
	double get_Latitude_NH_pos_dd() { return Latitude_NH_pos_dd; }
	double get_Longitude_WH_pos_dd() { return Longitude_WH_pos_dd; }

private:

	double Latitude_NH_pos_dd;
	double Longitude_WH_pos_dd;

    double Day_Angle_rad;
    double Equation_of_Time_HH_point_Mn;
    double Standard_Meridian_deg;
    double TrueSolarTime_HH_point_Mn;

	double DeclinationAngle_Solar_rad;
	double HourAngle_Solar_deg;
    double HourAngle_Solar_rad;
	
	double Cos_ZenithAngle_Solar;
	double ZenithAngle_Solar_rad;

	double Sin_AltitudeAngle_Solar;
	double AltitudeAngle_Solar_rad;

	double AzimuthAngle_Solar_S_0_rad;
	double AzimuthAngle_Solar_N_0_rad;
	double AzimuthAngle_Solar_N_0_deg;
	double Cos_IncidenceAngle_Solar;
	
};

#endif