#ifndef ShortVegInterceptionCalc_H
#define ShortVegInterceptionCalc_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include "../Inputs/Inputs.h"
#include "../DataFolder.h"

//Ratio of hour to seconds
#define Ratio_m_to_mm 1.0/1000.0

class ShortVegInterceptionCalc
{
	public:
		static void ShortVegInterceptionManager(Inputs *input, CompactRagged* beC, int MapPixel_ID, int DataFolder_ID, int timeStep);


	private:
		static void Interception_Rain_SVeg(Inputs *input, CompactRagged* beC, int MapPixel_ID, int DataFolder_ID, int timeStep);
		static void Interception_Snow_SVeg(Inputs *input, CompactRagged* beC, int MapPixel_ID, int DataFolder_ID, int timeStep);
		static void Unload_Snow_SVeg(Inputs *input, CompactRagged* beC, int MapPixel_ID, int DataFolder_ID, int timeStep);
		static void SnowMelt_by_Radiation_SVeg(Inputs *input, CompactRagged* beC, int MapPixel_ID, int DataFolder_ID, int timeStep);
};
#endif