#ifndef TreeInterceptionCalc_H
#define TreeInterceptionCalc_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include "../Inputs/Inputs.h"
#include "../DataFolder.h"

//Conversion m to mm
#define Ratio_m_to_mm 1.0/1000.0

class TreeInterceptionCalc 
{
	// TreeInterceptionCalc is a derived class from the base class ICalc
	// TreeInterceptionCalc inherits all member data and member functions from base class ICalc
	// The only function to inherit, and required to be included, is the calculate function
	public:
		static void TreeInterceptionManager(Inputs *input, CompactRagged* beC, int MapPixel_ID, int DataFolder_ID, int timeStep);


	private:
	    static void Interception_Rain_Tree(Inputs *input, CompactRagged* beC, int MapPixel_ID, int DataFolder_ID, int timeStep);
		static void Interception_Snow_Tree(Inputs *input, CompactRagged* beC, int MapPixel_ID, int DataFolder_ID, int timeStep);
		static void Unload_Snow_Tree(Inputs *input, CompactRagged* beC, int MapPixel_ID, int DataFolder_ID, int timeS);
		static void SnowMelt_by_Radiation_Tree(Inputs *input, CompactRagged* beC, int MapPixel_ID, int DataFolder_ID, int timeStep);
};
#endif