#include "CoolRiverOutputWriter.h"

void CoolRiverOutputWriter::calculationMethod1(Inputs* input, string inputDirectory, StreamTemperature* st, int& calcMethod, int& LengthSimulated_River_m, int& TotalTimeMod_CN)
{
	vector<vector<double>> modeledT_x0(LengthSimulated_River_m, vector<double>(TotalTimeMod_CN));
	vector<vector<double>> skyViewFactorE(LengthSimulated_River_m, vector<double>(TotalTimeMod_CN));
	vector<vector<double>> skyViewFactorW(LengthSimulated_River_m, vector<double>(TotalTimeMod_CN));
	vector<vector<double>> atmLW(LengthSimulated_River_m, vector<double>(TotalTimeMod_CN));
	vector<vector<double>> landCoverLW(LengthSimulated_River_m, vector<double>(TotalTimeMod_CN));
	vector<vector<double>> upToAirLW(LengthSimulated_River_m, vector<double>(TotalTimeMod_CN));
	vector<vector<double>> LW(LengthSimulated_River_m, vector<double>(TotalTimeMod_CN));
	vector<vector<double>> latent(LengthSimulated_River_m, vector<double>(TotalTimeMod_CN));
	vector<vector<double>> sensible(LengthSimulated_River_m, vector<double>(TotalTimeMod_CN));
	vector<vector<double>> sediment(LengthSimulated_River_m, vector<double>(TotalTimeMod_CN));
	vector<vector<double>> thermalExchange(LengthSimulated_River_m, vector<double>(TotalTimeMod_CN));
	vector<vector<double>> SW(LengthSimulated_River_m, vector<double>(TotalTimeMod_CN));
	vector<vector<double>> dirSW(LengthSimulated_River_m, vector<double>(TotalTimeMod_CN));
	vector<vector<double>> diffSW(LengthSimulated_River_m, vector<double>(TotalTimeMod_CN));
	//vector<vector<double>> t_minBased1(LengthSimulated_River_m, vector<double>(TotalTimeMod_CN * 60));

	//as 20210113 We may need to move this section of the code to CoolRiverCalcMethod.cpp in ProcAndCalcs and CoolRiver
	if (calcMethod == 1)
	{
		// For Steady State
		modeledT_x0 = st->getModT();
		dirSW = st->getSWDir_2D();
		diffSW = st->getSWDiff_2D();
		atmLW = st->getAtmLW();
		landCoverLW = st->getLcLW();
		upToAirLW = st->getBackLW();
		LW = st->getLW();
		latent = st->getLatent();
		sensible = st->getSensible();
		sediment = st->getBed();
		thermalExchange = st->getHeatFlux();
		SW = st->getSW();
		//t_minBased1 = st->getT_MinBased();
	}

}

void CoolRiverOutputWriter::calculationMethod2(Inputs* input, string inputDirectory, StreamTemperature* st, int &calcMethod, int &LengthSimulated_River_m, int &TotalTimeUns, int &CrossSectionsSimulated_cnt, int &TotalTimeMod)
{
	vector<vector<double>> Flux_Total_copy(LengthSimulated_River_m, vector<double>(TotalTimeUns));
	vector<vector<double>> Flux_Conduction_copy(LengthSimulated_River_m, vector<double>(TotalTimeUns));
	vector<vector<double>> Flux_Evaporation_copy(LengthSimulated_River_m, vector<double>(TotalTimeUns));
	vector<vector<double>> Flux_Convection_copy(LengthSimulated_River_m, vector<double>(TotalTimeUns));
	vector<vector<double>> FLux_AtmLW_copy(LengthSimulated_River_m, vector<double>(TotalTimeUns));
	vector<vector<double>> Flux_LCLW_copy(LengthSimulated_River_m, vector<double>(TotalTimeUns));
	vector<vector<double>> Flux_BackLW_copy(LengthSimulated_River_m, vector<double>(TotalTimeUns));
	vector<vector<double>> Flux_LW_copy(LengthSimulated_River_m, vector<double>(TotalTimeUns));
	vector<vector<double>> Flux_DirSW_copy(LengthSimulated_River_m, vector<double>(TotalTimeUns));
	vector<vector<double>> Flux_DiffSW_copy(LengthSimulated_River_m, vector<double>(TotalTimeUns));
	vector<vector<double>> Flux_SW_copy(LengthSimulated_River_m, vector<double>(TotalTimeUns));
	vector<vector<double>> T_Uns_copy(LengthSimulated_River_m, vector<double>(TotalTimeUns));
	vector<vector<double>> Depth_Uns_copy(LengthSimulated_River_m, vector<double>(TotalTimeUns));
	vector<vector<double>> Pw_unsteady_copy(LengthSimulated_River_m, vector<double>(TotalTimeUns));
	vector<vector<double>> width_UnsTotal_copy(LengthSimulated_River_m, vector<double>(TotalTimeUns));
	vector<vector<double>> depth_AvgUns_copy(LengthSimulated_River_m, vector<double>(TotalTimeUns));
	vector<vector<double>> Hyporheic_Exchange_copy(LengthSimulated_River_m, vector<double>(TotalTimeUns));
	vector<vector<double>> Rh_unsteady_copy(LengthSimulated_River_m, vector<double>(TotalTimeUns));

	vector<vector<double>> temp_Flux_Total(CrossSectionsSimulated_cnt, vector<double>(TotalTimeMod));
	vector<vector<double>> temp_Flux_Conduction(CrossSectionsSimulated_cnt, vector<double>(TotalTimeMod));
	vector<vector<double>> temp_Flux_Evaporation(CrossSectionsSimulated_cnt, vector<double>(TotalTimeMod));
	vector<vector<double>> temp_Flux_Convection(CrossSectionsSimulated_cnt, vector<double>(TotalTimeMod));
	vector<vector<double>> temp_FLux_AtmLW(CrossSectionsSimulated_cnt, vector<double>(TotalTimeMod));
	vector<vector<double>> temp_Flux_LCLW(CrossSectionsSimulated_cnt, vector<double>(TotalTimeMod));
	vector<vector<double>> temp_Flux_BackLW(CrossSectionsSimulated_cnt, vector<double>(TotalTimeMod));
	vector<vector<double>> temp_Flux_LW(CrossSectionsSimulated_cnt, vector<double>(TotalTimeMod));
	vector<vector<double>> temp_Flux_DirSW(CrossSectionsSimulated_cnt, vector<double>(TotalTimeMod));
	vector<vector<double>> temp_Flux_DiffSW(CrossSectionsSimulated_cnt, vector<double>(TotalTimeMod));
	vector<vector<double>> temp_Flux_SW(CrossSectionsSimulated_cnt, vector<double>(TotalTimeMod));
	vector<vector<double>> temp_T_Uns(CrossSectionsSimulated_cnt, vector<double>(TotalTimeMod));
	vector<vector<double>> temp_depth_Uns(CrossSectionsSimulated_cnt, vector<double>(TotalTimeMod));
	vector<vector<double>> temp_Pw_unsteady(CrossSectionsSimulated_cnt, vector<double>(TotalTimeMod));
	vector<vector<double>> temp_width_UnsTotal(CrossSectionsSimulated_cnt, vector<double>(TotalTimeMod));
	vector<vector<double>> temp_depth_AvgUns(CrossSectionsSimulated_cnt, vector<double>(TotalTimeMod));
	vector<vector<double>> temp_Hyporheic_Exchange(CrossSectionsSimulated_cnt, vector<double>(TotalTimeMod));
	vector<vector<double>> temp_Rh_unsteady(CrossSectionsSimulated_cnt, vector<double>(TotalTimeMod));

	//vector<double> temp_Hyporheic_Exchange(CrossSectionsSimulated_cnt);
	//vector<double> temp_Q_GW(CrossSectionsSimulated_cnt);

	if (calcMethod == 2)
	{
		// For Unsteady state
		Flux_Total_copy = st->get_TotalFlux();
		Flux_Conduction_copy = st->get_Conduction();
		Flux_Evaporation_copy = st->get_Evaporation();
		Flux_Convection_copy = st->get_Convection();
		FLux_AtmLW_copy = st->get_AtmLW();
		Flux_LCLW_copy = st->get_LCLW();
		Flux_BackLW_copy = st->get_BackLW();
		Flux_LW_copy = st->get_Flux_LW();
		Flux_DirSW_copy = st->get_Flux_DirSW();
		Flux_DiffSW_copy = st->get_Flux_DiffSW();
		Flux_SW_copy = st->get_Flux_SW();
		T_Uns_copy = st->get_T_Uns();
		Depth_Uns_copy = st->get_depth_Uns();

		temp_Flux_Total = st->get_hour_TotalFlux();
		temp_Flux_Conduction = st->get_hour_Conduction();
		temp_Flux_Evaporation = st->get_hour_Evaporation();
		temp_Flux_Convection = st->get_hour_Convection();
		temp_FLux_AtmLW = st->get_hour_AtmLW();
		temp_Flux_LCLW = st->get_hour_LCLW();
		temp_Flux_BackLW = st->get_hour_BackLW();
		temp_Flux_LW = st->get_hour_Flux_LW();
		temp_Flux_DirSW = st->get_hour_Flux_DirSW();
		temp_Flux_DiffSW = st->get_hour_Flux_DiffSW();
		temp_Flux_SW = st->get_hour_Flux_SW();
		temp_T_Uns = st->get_hour_T_Uns();
		temp_depth_Uns = st->get_hour_depth_Uns();

		//temp_Hyporheic_Exchange = st->getHypEx();
		//temp_Q_GW = st->getQ_GW();
	}

	// The vectors required for the HEC_RAS related calculation method (Jan. 18)
	// start

}


void CoolRiverOutputWriter::calculationMethod3(Inputs* input, string inputDirectory, StreamTemperature* st, int& calcMethod, int& LengthSimulated_River_m, int& TotalTime_HR, int& CrossSectionsSimulated_cnt)
{
	vector<vector<double>> temp_Flux_Evaporation_HR(LengthSimulated_River_m, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_Flux_Conduction_HR(LengthSimulated_River_m, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_Flux_Convection_HR(LengthSimulated_River_m, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_FLux_AtmLW_HR(LengthSimulated_River_m, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_Flux_LCLW_HR(LengthSimulated_River_m, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_Flux_BackLW_HR(LengthSimulated_River_m, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_Flux_LW_HR(LengthSimulated_River_m, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_Flux_DirSW_HR(LengthSimulated_River_m, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_Flux_DiffSW_HR(LengthSimulated_River_m, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_Flux_SW_HR(LengthSimulated_River_m, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_Flux_Total_HRdist(LengthSimulated_River_m, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_Temp_HRdist(LengthSimulated_River_m, vector<double>(TotalTime_HR));

	vector<vector<double>> temp_Flux_Evaporation_Nodes(CrossSectionsSimulated_cnt, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_Flux_Conduction_Nodes(CrossSectionsSimulated_cnt, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_Flux_Convection_Nodes(CrossSectionsSimulated_cnt, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_FLux_AtmLW_Nodes(CrossSectionsSimulated_cnt, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_Flux_LCLW_Nodes(CrossSectionsSimulated_cnt, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_Flux_BackLW_Nodes(CrossSectionsSimulated_cnt, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_Flux_LW_Nodes(CrossSectionsSimulated_cnt, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_Flux_DirSW_Nodes(CrossSectionsSimulated_cnt, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_Flux_DiffSW_Nodes(CrossSectionsSimulated_cnt, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_Flux_SW_Nodes(CrossSectionsSimulated_cnt, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_FluxTotal_HR(CrossSectionsSimulated_cnt, vector<double>(TotalTime_HR));
	vector<vector<double>> temp_HeatFluxADR_Temperature_C(CrossSectionsSimulated_cnt, vector<double>(TotalTime_HR));

	// For Debugging purpose-start
	//vector<vector<double>> temp_tempNodesDebugg(12, vector<double>(96));
	//temp_tempNodesDebugg = st->get_tempNodesDebugg();
	//vector<double> tempHyporheic_Exchange_HR(100);
	//tempHyporheic_Exchange_HR = st->getHypEx_HR();
	// For Debugging purpose-end

	if (calcMethod == 3)
	{
		temp_Flux_Evaporation_HR = st->get_EvapHRdist();
		temp_Flux_Conduction_HR = st->get_CondHRdist();
		temp_Flux_Convection_HR = st->get_ConvHRdist();
		temp_FLux_AtmLW_HR = st->get_AtmLWHRdist();
		temp_Flux_LCLW_HR = st->get_LCLWHRdist();
		temp_Flux_BackLW_HR = st->get_BackLWHRdist();
		temp_Flux_LW_HR = st->get_LWHRdist();
		temp_Flux_DirSW_HR = st->get_DirSWHRdist();
		temp_Flux_DiffSW_HR = st->get_DiffSWHRdist();
		temp_Flux_SW_HR = st->get_SWHRdist();
		temp_Flux_Total_HRdist = st->get_TotalFluxHRdist();
		temp_Temp_HRdist = st->get_TempHRdist();

		temp_Flux_Evaporation_Nodes = st->get_EvapHRnodes();
		temp_Flux_Conduction_Nodes = st->get_CondHRnodes();
		temp_Flux_Convection_Nodes = st->get_ConvHRnodes();
		temp_FLux_AtmLW_Nodes = st->get_get_AtmLWHRnodes();
		temp_Flux_LCLW_Nodes = st->get_LCLWHRnodes();
		temp_Flux_BackLW_Nodes = st->get_BackLWHRnodes();
		temp_Flux_LW_Nodes = st->get_LWHRnodes();
		temp_Flux_DirSW_Nodes = st->get_DirSWHRnodes();
		temp_Flux_DiffSW_Nodes = st->get_DiffSWHRnodes();
		temp_Flux_SW_Nodes = st->get_SWHRnodes();
		temp_FluxTotal_HR = st->get_TotalFluxHRnodes();
		temp_HeatFluxADR_Temperature_C = st->get_TempHRnodes();
	}

}

void CoolRiverOutputWriter::swtichCalMethod1True(Inputs *input, StreamTemperature* st, int &TotalDistMod, int &TotalTimeMod)
{
	// Writing the results for the steady state condition
		//Added River Station and time Step Strings as headers for output files
	twoDwriter(TotalDistMod, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->T, "Hourly_Temperature_C_deg", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(TotalDistMod, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->SWDir_2D, "Hourly_DirectSW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(TotalDistMod, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->SWDiff_2D, "Hourly_DiffuseSW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(TotalDistMod, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->atmLW_2D, "Hourly_AtmLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(TotalDistMod, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->LCLW_2D, "Hourly_LandcoverLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(TotalDistMod, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->backLW_2D, "Hourly_WaterBack2SkyLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(TotalDistMod, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->LW_2D, "Hourly_TotalLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(TotalDistMod, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->Latent_2D, "Hourly_LatentE_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(TotalDistMod, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->Sensible_2D, "Hourly_SensibleE_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(TotalDistMod, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->heat_flux_2D, "Hourly_TotalHeatFlux_J_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(TotalDistMod, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->SW_2D, "Hourly_TotalSW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(TotalDistMod, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->Bed_2D, "Hourly_SedimentConduction_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);

}

void CoolRiverOutputWriter::swtichCalMethod1False(Inputs* input, StreamTemperature* st, int& CrossSectionsSimulated_cnt, int& TotalTimeMod_CN)
{
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod_CN - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->t_minBased, "Minutely_Temperature_C_deg", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod_CN - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->heat_flux_2D_min, "Minutely_TotalHeatFlux_J_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod_CN - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->SWDir_2D_min, "Minutely_DirectSW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod_CN - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->SWDiff_2D_min, "Minutely_DiffuseSW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod_CN - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->SW_2D_min, "Minutely_TotalSW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod_CN - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->LW_2D_min, "Minutely_TotalLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod_CN - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->atmLW_2D_min, "Minutely_AtmLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod_CN - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->LCLW_2D_min, "Minutely_LandcoverLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod_CN - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->backLW_2D_min, "Minutely_WaterBack2SkyLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod_CN - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->Latent_2D_min, "Minutely_LatentE_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod_CN - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->Sensible_2D_min, "Minutely_SensibleE_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod_CN - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->Bed_2D_min, "Minutely_SedimentConduction_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
}

void CoolRiverOutputWriter::swtichCalMethod3ExtTrue(Inputs* input, StreamTemperature* st, int& CrossSectionsSimulated_cnt, int& TotalTimeModHR)
{
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->DeltaTotal_HR, "Hourly_DeltaTotalHR", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->DepthAvgALL_HR, "Hourly_RiverAvgDepth_m", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->AreaALL_HR, "Hourly_RiverXSArea_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->VelocityALL_HR, "Hourly_RiverVelocity_m_per_s", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->WidthALL_HR, "Hourly_RiverWidth_m", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->HeatFluxRetentionTime_p_dt, "Hourly_RiverRetentionTime_s", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->Pw_ALL_HR, "Hourly_RiverWettedPerimeter_m", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->WSElev_ALL_HR, "Hourly_RiverWaterSurfElev_m", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->Q_Str_HR, "Hourly_RiverQDischarge_m3_per_s", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->HyporheicExchange_HR, "Hourly_HyporheicExchange_m3_per_s", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->Dispersion_HR, "Hourly_LongDispersion_m2_per_s", input->SimulationStringParams["OutputFolder_Path"]);

}

void CoolRiverOutputWriter::swtichCalMethod3True(Inputs* input, StreamTemperature* st, int& CrossSectionsSimulated_cnt, int& TotalTimeModHR)
{
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->HeatFluxADR_Temperature_C, "Hourly_Temperature_C_deg", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->FluxTotal_HR, "Hourly_TotalHeatFlux_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->Flux_SW_Nodes, "Hourly_TotalSW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->Flux_DirSW_Nodes, "Hourly_DirectSW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->Flux_DiffSW_Nodes, "Hourly_DiffuseSW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->Flux_LW_Nodes, "Hourly_TotalLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->Flux_LCLW_Nodes, "Hourly_LandcoverLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->Flux_BackLW_Nodes, "Hourly_WaterBack2SkyLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->FLux_AtmLW_Nodes, "Hourly_AtmLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->Flux_Convection_Nodes, "Hourly_SensibleE_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->Flux_Conduction_Nodes, "Hourly_SedimentConduction_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeModHR, "RiverStation_ID", "TimeStep_ID", st->Flux_Evaporation_Nodes, "Hourly_LatentE_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
}

void CoolRiverOutputWriter::swtichCalMethod3FalseExtTrue(Inputs* input, StreamTemperature* st, int& CrossSectionsSimulated_cnt, int& TotalTime_HR)
{
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->delta_2D_min, "Minutely_DeltaTotalHR", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->depthAvgALL_2D_min, "Minutely_RiverAvgDepth_m", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->AreaALL_2D_min, "Minutely_RiverXSArea_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->VelocityALL_2D_min, "Minutely_RiverVelocity_m_per_s", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->WidthALL_2D_min, "Minutely_RiverWidth_m", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->RetentionT_2D_min, "Minutely_RiverRetentionTime_s", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->Pw_ALL_2D_min, "Minutely_RiverWettedPerimeter_m", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->WSElev_ALL_2D_min, "Minutely_RiverWaterSurfElev_m", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->Q_Str_2D_min, "Minutely_RiverQDischarge_m3_per_s", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->HyporheicExchange_2D_min, "Minutely_HyporheicExchange_m3_per_s", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->Dispersion_2D_min, "Minutely_LongDispersion_m2_per_s", input->SimulationStringParams["OutputFolder_Path"]);
}

void CoolRiverOutputWriter::swtichCalMethod3False(Inputs* input, StreamTemperature* st, int& CrossSectionsSimulated_cnt, int& TotalTime_HR)
{
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->t_minBased, "Minutely_Temperature_C_deg", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->heat_flux_2D_min, "Minutely_TotalHeatFlux_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->SWDir_2D_min, "Minutely_DirectSW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->SWDiff_2D_min, "Minutely_DiffuseSW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->SW_2D_min, "Minutely_TotalSW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->LW_2D_min, "Minutely_TotalLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->atmLW_2D_min, "Minutely_AtmLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->LCLW_2D_min, "Minutely_LandcoverLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->backLW_2D_min, "Minutely_WaterBack2SkyLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->Latent_2D_min, "Minutely_LatentE_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->Sensible_2D_min, "Minutely_SensibleE_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTime_HR, "RiverStation_ID", "TimeStep_ID", st->Bed_2D_min, "Minutely_SedimentConduction_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);

}

void CoolRiverOutputWriter::swtichCalMethod2ExtTrue(Inputs* input, StreamTemperature* st, int& CrossSectionsSimulated_cnt, int& TotalTimeMod)
{
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->hour_depth_Uns, "Hourly_WaterDepth_m", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->hour_Pw_unsteady, "Hourly_WettedPerimeter_m", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->hour_width_UnsTotal, "Hourly_WaterWidth_m", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->hour_depth_AvgUns, "Hourly_WaterAvgDepth_m", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->hour_Hyporheic_Exchange, "Hourly_HyporheicExchange", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->hour_Rh_unsteady, "Hourly_HydraulicRadius_m", input->SimulationStringParams["OutputFolder_Path"]);
}

void CoolRiverOutputWriter::swtichCalMethod2True(Inputs* input, StreamTemperature* st, int& CrossSectionsSimulated_cnt, int& TotalTimeMod)
{
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->hour_Flux_Total, "Hourly_TotalHeatFlux_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->hour_T_Uns, "Hourly_Temperature_C_deg", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->hour_Flux_Conduction, "Hourly_SedimentConduction_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->hour_Flux_Evaporation, "Hourly_LatentE_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->hour_Flux_Convection, "Hourly_Sensible_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->hour_FLux_AtmLW, "Hourly_AtmLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->hour_Flux_LCLW, "Hourly_LandcoverLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->hour_Flux_BackLW, "Hourly_WaterBack2SkyLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->hour_Flux_LW, "Hourly_TotalLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->hour_Flux_DirSW, "Hourly_DirectSW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->hour_Flux_DiffSW, "Hourly_DiffuseSW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, TotalTimeMod, "RiverStation_ID", "TimeStep_ID", st->hour_Flux_SW, "Hourly_TotalSW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
}

void CoolRiverOutputWriter::swtichCalMethod2FalseExtTrue(Inputs* input, StreamTemperature* st, int& CrossSectionsSimulated_cnt, int& TotalTimeMod)
{
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->depth_Uns, "Minutely_RiverDepth_m", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->Pw_unsteady_2D_min, "Minutely_RiverWettedPerimeter_m", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->width_UnsTotal_2D_min, "Minutely_RiverWidth_m", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->depth_AvgUns_2D_min, "Minutely_RiverAvgDepth_m", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->Hyporheic_Exchange_2D_min, "Minutely_HyporheicExchange_m3_per_s", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->Rh_unsteady_2D_min, "Minutely_HydraulicRadius_m", input->SimulationStringParams["OutputFolder_Path"]);
}

void CoolRiverOutputWriter::swtichCalMethod2False(Inputs* input, StreamTemperature* st, int& CrossSectionsSimulated_cnt, int& TotalTimeMod)
{
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->t_minBased, "Minutely_Temperature_C_deg", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->heat_flux_2D_min, "Minutely_TotalHeatFlux_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->Bed_2D_min, "Minutely_SedimentConduction_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->Latent_2D_min, "Minutely_LatentE_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->Sensible_2D_min, "Minutely_SensibleE_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->atmLW_2D_min, "Minutely_AtmLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->LCLW_2D_min, "Minutely_LandcoverLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->backLW_2D_min, "Minutely_WaterBack2SkyLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->LW_2D_min, "Minutely_TotalLW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->SWDir_2D_min, "Minutely_DirectSW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->SWDiff_2D_min, "Minutely_DiffuseSW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
	twoDwriter(CrossSectionsSimulated_cnt, (TotalTimeMod - 1) * 60, "RiverStation_ID", "TimeStep_ID", st->SW_2D_min, "Minutely_TotalSW_W_per_m2", input->SimulationStringParams["OutputFolder_Path"]);
}


void CoolRiverOutputWriter::twoDwriter(int sizeX, int sizeY, string RiverStation_str, string TimeStep_str, vector<vector<double>>& vector, string title, string OutputDir)
{

	title = OutputDir + "2D_" + title + ".csv";
	ofstream outfileC(title);

	if (!outfileC.good()) {
		cout << "Warning: Output folder does not exist or an output file in that folder is open and cannot be overwritten." << endl;
		cout << "Aborting: This warning triggers the HydroPlus simulation to abort." << endl;
		cout << "Correction: Confirm the HydroPlusConfig.xml parameter OutputFolder_Path and files in that folder are closed." << endl;
		//Call abort function, which ends the HydroPlus.exe simulation
		abort();
	}
	//Note: Consider Refactor to write out river stations 0m to CR_totDist. It appears that the for loop below stops before CR_totDist.
	//Note: The 2D output files, e.g., 2D_Hourly_SedimentConduction_W_per_m2.csv, have RiverStation_ID_0 to RiverStation_ID_14, ...
	//Note: ... while CR_unsteady_dx = 100 and CR_totDist = 1500 m, evidently writing only river stations 0m to 1400m, or 100m to 1500m.
	vector.resize(sizeX);
	//adding row and column headers for the output files.
	outfileC << RiverStation_str << ",";
	//k is representing time step to handle in separate loop
	for (int k = 0; k < sizeY; k++)
	{
		//taking string values as an input to column headers
		outfileC << TimeStep_str
			<< "_" << k << ",";
	}
	outfileC << '\n';

	//Truncate_1E_negative2 created to implement a rounding to two deciimal places 
	double Truncate_1E_negative2 = 0.01;

	for (int i = 0; i < sizeX; i++)
	{
		//taking string values as an input to row headers
		outfileC << RiverStation_str << "_" << i << ",";
		vector[i].resize(sizeY);

		//For loop through sizeY of vector
		for (int j = 0; j < sizeY; j++) {
			//taking the 2D vectors as output i = river station, j = time step
			//Variable_2DigitAccuracy created to take floor of vector[i][j] at precision of Truncate_1E_negative2 
			double Variable_2DigitAccuracy = floor(vector[i][j] / Truncate_1E_negative2 + 0.5) * Truncate_1E_negative2;
			outfileC << Variable_2DigitAccuracy << ",";
		}
		//next line
		outfileC << '\n';
	}
}