#ifndef CoolRiverOutputWriter_H
#define CoolRiverOutputWriter_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#include "../SimulationCoordinator.h"
#include "../CoolRiver/StreamTemperature.h"

using namespace std;

class CoolRiverOutputWriter
{
public:

	CoolRiverOutputWriter()
	{

	}

	~CoolRiverOutputWriter()
	{

	}
	
	static void calculationMethod1(Inputs* input, string inputDirectory, StreamTemperature* st, int& calcMethod, int& LengthSimulated_River_m, int& TotalTimeMod_CN);
	static void calculationMethod2(Inputs* input, string inputDirectory, StreamTemperature* st, int& calcMethod, int& LengthSimulated_River_m, int& TotalTimeUns, int& CrossSectionsSimulated_cnt, int& TotalTimeMod);
	static void calculationMethod3(Inputs *input, string inputDirectory, StreamTemperature* st, int& calcMethod, int& LengthSimulated_River_m, int& TotalTime_HR, int& CrossSectionsSimulated_cnt);

	static void twoDwriter(int sizeX, int sizeY, string a, string b, vector<vector<double>>& vector, string title, string OutputDir);
	
	static void swtichCalMethod1True(Inputs* input, StreamTemperature* st, int& TotalDistMod, int& TotalTimeMod);
	static void swtichCalMethod1False(Inputs* input, StreamTemperature* st, int& CrossSectionsSimulated_cnt, int& TotalTimeMod_CN);
	
	static void swtichCalMethod3ExtTrue(Inputs *input,StreamTemperature *st, int &CrossSectionsSimulated_cnt, int &TotalTimeModHR);
	static void swtichCalMethod3True(Inputs *input, StreamTemperature* st, int &CrossSectionsSimulated_cnt, int& TotalTimeModHR);
	static void swtichCalMethod3FalseExtTrue(Inputs *input, StreamTemperature *st, int &CrossSectionsSimulated_cnt, int& TotalTime_HR);
	static void swtichCalMethod3False(Inputs *input, StreamTemperature *st, int &CrossSectionsSimulated_cnt, int &TotalTime_HR);

	static void swtichCalMethod2ExtTrue(Inputs *input, StreamTemperature *st, int &CrossSectionsSimulated_cnt,int &TotalTimeMod);
	static void swtichCalMethod2True(Inputs *input, StreamTemperature *st, int &CrossSectionsSimulated_cnt, int &TotalTimeMod);
	static void swtichCalMethod2FalseExtTrue(Inputs *input,StreamTemperature *st, int& CrossSectionsSimulated_cnt,int &TotalTimeMod);
	static void swtichCalMethod2False(Inputs *input, StreamTemperature *st, int &CrossSectionsSimulated_cnt, int &TotalTimeMod);

};
#endif