#ifndef WaterQuality_Output_H
#define WaterQuality_Output_H
/*
* HydroPlus is source code and models developed and managed by Theodore Endreny and his students at SUNY ESF, te@esf.edu
* The US Forest Service and Davey Tree have provided strategic software development support through funding and personnel
* Attribution for use of software and code is requested. Please see Executive.cpp for documentation.
*/
#pragma once
#include "../Inputs/Inputs.h"
#include "../DataFolder.h"
#include <iostream>
#include <iomanip>
#include <fstream>
#include <vector>
#include <string>

using namespace std;

class WaterQuality_Output {
public:
	
	static void writeLoad_by_EMC_via_Catchment_TS(Inputs* input, int timeStep);
	static void writeLoad_by_EMC_via_GI_TS(Inputs* input, int timeStep);
	static void writeLoad_by_EMC_via_GI_Sum(Inputs* input);
	static void writeLoad_Pollutant_Sum(Inputs* input);
	static void writeLoad_BufferDynamic(const vector<double>& result, const vector<double>& Year, Inputs* input, const string& pollutant);
	static void writeLoad_BufferDynamic_extended(vector <pair<string, vector<double>>> &result_map, Inputs* input, const string& pollutant);

};
#endif