ptf #
<HydroPlusConfig>
 <SimulationStringParams>
    <OutputFolder_Path>C:\iTree\HydroPlus\TestingFilesAndScript\TestCases\Calibration\Hydro_WaterTable_2Obs\output\</OutputFolder_Path><!-- Output folder path ending with \-->
    <Model_Selection>StatisticalHydro</Model_Selection><!--Options: StatisticalHydro|SpatialTemperatureHydro|LCScalingTempSpatial|CoolRiver|ECDynamic-->
    <Algorithm_SoilKsatDecay>ExponentialDecay</Algorithm_SoilKsatDecay><!--Options: ExponentialDecay |  PowerDecay-->
    <Algorithm_FlowDirection>DInfinity</Algorithm_FlowDirection><!--Options: DInfinity |  MFD |  D8; Describes DEM flow routing method-->
    <TimeStep_CompareToObservedRunoff_str>Hour</TimeStep_CompareToObservedRunoff_str><!--Options: Hour | Day | Week | Month-->
    <Default_DrawerID_FolderID>0,0</Default_DrawerID_FolderID><!--Options: >=0; ID of DataDrawer & DataFolder w/ universal standard parameters for models-->
 </SimulationStringParams>
 <SimulationNumericalParams>
    <StartDate_YYYYMMDD>20181001</StartDate_YYYYMMDD><!--Options: YYYYMMDD or YYYYMMDDHH; Must be in meteorological input files-->
    <StopDate_YYYYMMDD>20181002</StopDate_YYYYMMDD><!--Options: YYYYMMDD or YYYYMMDDHH; Must be in meteorological input files-->
    <CatchmentArea_m2>161440000</CatchmentArea_m2><!--Options: > 0; total simulated area within DEM.asc, excluding -9999; units m^2-->
    <TopographicIndexBins>30</TopographicIndexBins><!-- Options: 1 to 30; bins for topographic index-->
    <TimeStep_sec>3600</TimeStep_sec><!--Options: 0 or higher; averaging time step represented by first meteorological input; units s-->
    <Height_Sensor_Wind_m>10.0</Height_Sensor_Wind_m><!-- Options: > 0; height at which wind speed measured; units m-->
    <Height_Sensor_Tair_m>2.0</Height_Sensor_Tair_m><!-- Options: > 0; height at which air temperature is measured; units m-->
    <Flag_OutputTime_DST>0</Flag_OutputTime_DST><!-- Options: 0=Output timestamp same as input Standard Time; 1=Output timestamp converted to Daylight Saving Time-->
    <Flag_ExtendedOutputs>1</Flag_ExtendedOutputs><!-- Options: 0=None 1=Time series written-->
    <Flag_Recompute_TopographicIndex>1</Flag_Recompute_TopographicIndex><!--Options: 0 or 1; 0=Use existing TI data 1=Recompute TI data-->
    <Flag_TI_PerviousOnly>0</Flag_TI_PerviousOnly><!--Options: 0 or 1; 0=TI from entire area 1=TI from pervious area as TopUrban by Valeo-->
	<Flag_ReadEvaporationData>0</Flag_ReadEvaporationData><!--Options: 0=Evaporation calculated in model; 1=Evaporation.csv provided-->
    <Flag_DEM_RemovePitsFlats>0</Flag_DEM_RemovePitsFlats><!--Options:0 or 1; 0=DEM unchanged; 1=DEM pits and flats removed-->
    <Flag_CoolAir_AnthropogenicHeat_Flux>0</Flag_CoolAir_AnthropogenicHeat_Flux><!--Options: 0 or 1; 0=No AH4GUC Map Inputs 1=AH4GUC Map Inputs-->
    <Flag_CompareToObservedRunoff>0</Flag_CompareToObservedRunoff><!--Options: 0=Not compared; 1=Compared if output provided-->
 </SimulationNumericalParams>
 <SimulationScenarios>
	<Flag_Scenario_CoolAir_LandCover>1</Flag_Scenario_CoolAir_LandCover><!--Options: Scenarios 0-3; 0=none;1=base TCI created;2=alt TC increased;3=alt TCI created and TC increased-->
	<Scenario_CoolAir_Base_TCI_to_TC_frac>0.0</Scenario_CoolAir_Base_TCI_to_TC_frac><!--Options: Base case TreeCanopyCover_overImpervious_frac to compare with alternative-->
	<Scenario_CoolAir_Alternative_TC_Min_frac>0.0</Scenario_CoolAir_Alternative_TC_Min_frac><!--Options: Alternative case tree cover minimum fractional value for urban NLCD classes-->
 </SimulationScenarios>
 <DataOrganizer>
  <DataDrawer>
   <DataFolder>
	<Type>BulkArea</Type><!-- Options: BulkArea; BulkArea required for 1st DataFolder in DataDrawer-->
    <Area_m2>161440000</Area_m2><!--Options: Hydro = CatchmentArea_m2 - all other Area; CoolAir = cellsize^2; units m^2-->
     <TreeCanopyCover_overPervious_frac>0.363</TreeCanopyCover_overPervious_frac><!--Options: >= 0; tree canopy over pervious; units fraction-->
     <TreeCanopyCover_overImpervious_frac>0.05</TreeCanopyCover_overImpervious_frac><!--Options: >= 0; tree canopy over impervious; in CoolAir model limited to NLCD Class=21 TC; units fraction-->
     <ShortVegCover_noTreeCanopy_frac>0.297</ShortVegCover_noTreeCanopy_frac><!--Options: >= 0; short vegetation no tree canopy; units fraction-->
     <SoilCover_noTreeCanopy_frac>0.007</SoilCover_noTreeCanopy_frac><!--Options: >= 0; soil no tree canopy; units fraction-->
     <WaterCover_noTreeCanopy_frac>0.083</WaterCover_noTreeCanopy_frac><!--Options: >= 0; water no tree canopy; units fraction-->
     <ImperviousCover_noTreeCanopy_frac>0.2</ImperviousCover_noTreeCanopy_frac><!--Options: >= 0; impervious no tree canopy; units fraction-->
     <DirectlyConnectedImperviousArea_frac>0.2685</DirectlyConnectedImperviousArea_frac><!--Options: 0 to 1; directly connected impervious area draining to outlet; units fraction-->
    <PerviousDepressionStorage_TreeCover_mm>5.0</PerviousDepressionStorage_TreeCover_mm><!--Options: >=0; average ponding depth; units mm-->
    <PerviousDepressionStorage_SVegCover_mm>2.5</PerviousDepressionStorage_SVegCover_mm><!--Options: >=0; average ponding depth; units mm-->
    <PerviousDepressionStorage_SoilCover_mm>1.5</PerviousDepressionStorage_SoilCover_mm><!--Options: >=0; average ponding depth; units mm-->
    <ImperviousDepressionStorage_noTreeCover_mm>1.5</ImperviousDepressionStorage_noTreeCover_mm><!--Options: >=0; average ponding depth; units mm-->
    <ImperviousDepressionStorage_TreeCover_mm>2.5</ImperviousDepressionStorage_TreeCover_mm><!--Options: >=0; average ponding depth; units mm-->
    <WaterDepressionStorage_mm>0.0</WaterDepressionStorage_mm><!-- Options: >=0; average storage depth; units mm-->
    <Soil_Macropore_TreeCover_frac>0.1</Soil_Macropore_TreeCover_frac><!--Options: 0 to 1; determines fraction of infiltration bypassing rootzone-->
    <Soil_Macropore_SVegCover_frac>0.05</Soil_Macropore_SVegCover_frac><!--Options: 0 to 1; determines fraction of infiltration bypassing rootzone-->
    <Soil_Macropore_SoilCover_frac>0.01</Soil_Macropore_SoilCover_frac><!--Options: 0 to 1; determines fraction of infiltration bypassing rootzone-->
    <Soil_WiltingPoint_m3pm3>0.14</Soil_WiltingPoint_m3pm3><!-- Options: 0 to 1; soil wilting point; units m3/m3-->
    <Soil_FieldCapacity_m3pm3>0.24</Soil_FieldCapacity_m3pm3><!--  Options: 0 to 1; soil field capacity; units m3/m3-->
    <Soil_SaturationPoint_m3pm3>0.4</Soil_SaturationPoint_m3pm3><!-- Options: 0 to 1; soil saturation point; units m3/m3-->
    <Soil_Porosity_m3pm3>0.4</Soil_Porosity_m3pm3><!-- Options: 0 to 1; soil porosity; units m3/m3-->
    <Soil_MoistureInitial_m3pm3>0.24</Soil_MoistureInitial_m3pm3><!-- Options: 0 to 1; initial moisture point; units m3/m3-->
    <InfiltExcessGovernedArea_frac>1.0</InfiltExcessGovernedArea_frac><!-- Options: 0 to 1; area with Green-Ampt infiltration; units fraction-->
    <Soil_Ksat_mph>0.003</Soil_Ksat_mph><!-- Defines soil hydraulic conductivity at saturation; units m/h-->
    <Soil_WettingFront_Suction_m>0.66</Soil_WettingFront_Suction_m><!-- Options: > 0; soil wetting front suction for Green-Ampt infiltration; units m-->
    <EvapotranspirationDepth_TreeCover_m>1.0</EvapotranspirationDepth_TreeCover_m><!--Options: >=0; depth accessible to evapotranspiration demand; units m-->
    <EvapotranspirationDepth_SVegCover_m>0.5</EvapotranspirationDepth_SVegCover_m><!--Options: >=0; depth accessible to evapotranspiration demand; units m-->
    <EvapotranspirationDepth_SoilCover_m>0.2</EvapotranspirationDepth_SoilCover_m><!--Options: >=0; depth accessible to evapotranspiration demand; units m-->
    <VadoseZone_Drainage_Delay_h>10</VadoseZone_Drainage_Delay_h><!-- Options: >0; time delay in draining unsaturated zone; units h-->
    <Discharge_Subsurface_Initial_mph>#Discharge_S0#</Discharge_Subsurface_Initial_mph><!-- Options: > 0; initial stream discharge and soil moisture deficit; units m/h-->
    <VadoseZone_Transmissivity_Max_m2ph>#VadoseZone_1#</VadoseZone_Transmissivity_Max_m2ph><!-- Defines soil transmissivity when entire soil depth is saturated; units m^2/h-->
    <Parameter_m_KsatExpDecay>#Parameter_m2#</Parameter_m_KsatExpDecay><!--Options: >0; Scale parameter for decay of hydraulic conductivity with depth; unitless-->
    <Parameter_n_KsatPowerDecay>2</Parameter_n_KsatPowerDecay><!--Options: 1 or 2; Power for decay of hydraulic conductivity with depth; unitless-->
    <Routing_PerviousArea_Alpha_h>40.0</Routing_PerviousArea_Alpha_h><!-- Options: > 0; time constant a for pervious area flow; units h-->
    <Routing_PerviousArea_Beta_h>40.0</Routing_PerviousArea_Beta_h><!-- Options: > 0; time constant b for pervious area flow; units h-->
    <Routing_ImperviousArea_Alpha_h>40.0</Routing_ImperviousArea_Alpha_h><!-- Options: > 0; time constant a for impervious area flow; units h-->
    <Routing_ImperviousArea_Beta_h>40.0</Routing_ImperviousArea_Beta_h><!-- Options: > 0; time constant b for impervious area flow; units h-->
    <Routing_Subsurface_Beta_h>120.0</Routing_Subsurface_Beta_h><!-- Options: > 0; time constant for subsurface flow; units h-->
    <LeafOnDate_JDay>97</LeafOnDate_JDay><!-- Option: 1 to maximum Julian Day in Year; day when tree reaches maximum LAI-->
    <LeafOffDate_JDay>297</LeafOffDate_JDay><!-- Option: value > LeafOnDay; day when deciduous leaf has LAI = 0-->
    <LeafTransition_Day>28</LeafTransition_Day><!-- Option: >=0; days for LAI to transition from bud break to full leaf, from min LAI to max LAI-->
    <LeafAreaIndex_Tree_m2pm2>5</LeafAreaIndex_Tree_m2pm2><!-- Options: >=0; average value of maximum LAI for tree canopy; units m^2/m^2-->
    <LeafAreaIndex_SVeg_m2pm2>2.2</LeafAreaIndex_SVeg_m2pm2><!-- Options: >=0; average value of maximum LAI for short veg canopy; units m^2/m^2-->
    <TreeCover_Evergreen_frac>0.01</TreeCover_Evergreen_frac><!-- Options: 0 to 1; Portion of tree cover that is evergreen-->
    <BarkAreaIndex_Tree_m2pm2>1.7</BarkAreaIndex_Tree_m2pm2><!-- Options: 0 or higher; Bark area index, BAI, for canopy area w/ units m^2/m^2-->
    <SVegCover_Evergreen_frac>0.1</SVegCover_Evergreen_frac><!-- Options: 0 to 1; Portion of veg cover that is evergreen-->
    <BarkAreaIndex_SVeg_m2pm2>0.5</BarkAreaIndex_SVeg_m2pm2><!-- Options: 0 or higher; Bark area index, BAI, for canopy area w/ units m^2/m^2-->
    <LeafAreaStorage_Tree_mm>0.2</LeafAreaStorage_Tree_mm><!--Options: >=0; liquid storage depth maximum-->
    <BarkAreaStorage_Tree_mm>0.2</BarkAreaStorage_Tree_mm><!--Options: >=0; liquid storage depth maximum-->
    <LeafAreaStorage_SVeg_mm>0.2</LeafAreaStorage_SVeg_mm><!--Options: >=0; liquid storage depth maximum-->
    <BarkAreaStorage_SVeg_mm>0.2</BarkAreaStorage_SVeg_mm><!--Options: >=0; liquid storage depth maximum-->
    <SVeg_in_Gap_DevelopedArea_frac>0.5</SVeg_in_Gap_DevelopedArea_frac><!--Options: 0 to 1; SVeg if TC+IC leave a gap else Soil for NLCD Class 21-24; units frac-->
    <Height_Avg_TreeCover_m>12</Height_Avg_TreeCover_m><!-- Options: > 0; roughness height for evaporation resistance; units m-->
    <Height_Avg_SVegCover_m>0.05</Height_Avg_SVegCover_m><!-- Options: > 0; roughness height for evaporation resistance; units m-->
   </DataFolder>
  </DataDrawer>
 </DataOrganizer>
 <SimulationLocationParams>
 </SimulationLocationParams>
</HydroPlusConfig>