﻿//WARNING: Do not update RestSharp beyond 106.x due to dependency on SqlWeb.Data and RestClient.ClearHandlers().

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;

namespace WeatherPrep
{
    public class ConfigData
    {
        public string Model;
        public string Nation;
        public string State;
        public string County;
        public string Place;
        public double MaximumLAI;
        public double EvergreenPercent;
        public VEGTYPE VegType;
        public int StartYear;
        public int EndYear;
        public double TreeHeight;
        public double WindSensorHeight;
        public string WeatherDataPath;
        public string PrecipDataPath;
        public string LAIDatabasePath;
        public string Meteo_DatabasePath;
    }

    public static class ReadWeatherPrepConfig
    {
        public static ConfigData Load(string configFolder)
        {
            string filePath = Path.Combine(configFolder, "WeatherPrepConfig.xml");

            var config = new ConfigData
            {
                LAIDatabasePath = Path.Combine(configFolder, "LAI.csv"),
                Meteo_DatabasePath = Path.Combine(configFolder, "Meteo.csv")
            };

            using (XmlReader reader = XmlReader.Create(filePath))
            {
                while (reader.Read())
                {
                    if (reader.IsStartElement())
                    {
                        switch (reader.Name)
                        {
                            case "Model": config.Model = reader.ReadString(); break;
                            case "Nation": config.Nation = reader.ReadString(); break;
                            case "State": config.State = reader.ReadString(); break;
                            case "County": config.County = reader.ReadString(); break;
                            case "Place": config.Place = reader.ReadString(); break;
                            case "MaximumLAI": config.MaximumLAI = double.Parse(reader.ReadString()); break;
                            case "EvergreenPercent": config.EvergreenPercent = double.Parse(reader.ReadString()); break;
                            case "VegetationType":
                                string veg = reader.ReadString();
                                switch (veg)
                                {
                                    case "Tree":
                                        config.VegType = VEGTYPE.TREE;
                                        break;
                                    case "Shrub":
                                        config.VegType = VEGTYPE.SHRUB;
                                        break;
                                    case "Grass":
                                        config.VegType = VEGTYPE.GRASS;
                                        break;
                                    default:
                                        throw new Exception("Invalid VegetationType: " + veg);
                                }
                                break;
                            case "Height_Tree_m": config.TreeHeight = double.Parse(reader.ReadString()); break;
                            case "Height_WindSensor_m": config.WindSensorHeight = double.Parse(reader.ReadString()); break;
                            case "StartYear": config.StartYear = int.Parse(reader.ReadString()); break;
                            case "EndYear": config.EndYear = int.Parse(reader.ReadString()); break;
                            case "SurfaceWeatherDataFile": config.WeatherDataPath = reader.ReadString(); break;
                            case "PrecipitationDataCsv": config.PrecipDataPath = reader.ReadString(); break;
                        }
                    }
                }
            }

            // Defaults
            if (config.TreeHeight == 0) config.TreeHeight = 12;
            if (config.WindSensorHeight == 0) config.WindSensorHeight = 10;
            if (config.EndYear < config.StartYear) config.EndYear = config.StartYear;

            Console.WriteLine("Below are the input data from: " + Path.Combine(configFolder, "WeatherPrepConfig.xml") + "\n");

            Console.WriteLine("Model is: " + config.Model);
            Console.WriteLine("Nation is: " + config.Nation);
            Console.WriteLine("State is: " + config.State);
            Console.WriteLine("County is: " + config.County);
            Console.WriteLine("Place is: " + config.Place);
            Console.WriteLine("MaximumLAI is: " + config.MaximumLAI);
            Console.WriteLine("EvergreenPercent is: " + config.EvergreenPercent);
            Console.WriteLine("VegetationType is: " + config.VegType);
            Console.WriteLine("Height_Tree_m is: " + config.TreeHeight);
            Console.WriteLine("Height_WindSensor_m is: " + config.WindSensorHeight);
            Console.WriteLine("StartYear is: " + config.StartYear);
            Console.WriteLine("EndYear is: " + config.EndYear);
            Console.WriteLine("Weather station data provided: " + config.WeatherDataPath);

            if (!string.IsNullOrEmpty(config.PrecipDataPath))
            {
                Console.WriteLine("Precipitation data provided: " + config.PrecipDataPath);
            }


            return config;
        }
    }

}
